/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import jdk.jfr.AnnotationElement;
import jdk.jfr.Description;
import jdk.jfr.Event;
import jdk.jfr.Label;
import jdk.jfr.MetadataDefinition;
import jdk.jfr.Name;
import jdk.jfr.SettingDescriptor;
import jdk.jfr.Timespan;
import jdk.jfr.Timestamp;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.internal.Control;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.MetadataHandler;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.Utils;

public final class TypeLibrary {
    private static TypeLibrary instance;
    private static final Map<Long, Type> types;
    static final ValueDescriptor DURATION_FIELD;
    static final ValueDescriptor THREAD_FIELD;
    static final ValueDescriptor STACK_TRACE_FIELD;
    static final ValueDescriptor START_TIME_FIELD;

    private TypeLibrary(List<Type> jvmTypes) {
        TypeLibrary.visitReachable(jvmTypes, t -> !types.containsKey(t.getId()), t -> types.put(t.getId(), (Type)t));
        if (Logger.shouldLog(LogTag.JFR_SYSTEM_METADATA, LogLevel.INFO)) {
            Stream<Type> s = types.values().stream().sorted((x, y) -> Long.compare(x.getId(), y.getId()));
            s.forEach(t -> t.log("Added", LogTag.JFR_SYSTEM_METADATA, LogLevel.INFO));
        }
    }

    private static ValueDescriptor createStartTimeField() {
        List<AnnotationElement> annos = TypeLibrary.createStandardAnnotations("Start Time", null);
        annos.add(new AnnotationElement(Timestamp.class, "TICKS"));
        return PrivateAccess.getInstance().newValueDescriptor("startTime", Type.LONG, annos, 0, false, "startTime");
    }

    private static ValueDescriptor createStackTraceField() {
        ArrayList<AnnotationElement> annos = new ArrayList();
        annos = TypeLibrary.createStandardAnnotations("Stack Trace", "Stack Trace starting from the method the event was committed in");
        return PrivateAccess.getInstance().newValueDescriptor("stackTrace", Type.STACK_TRACE, annos, 0, true, "stackTrace");
    }

    private static ValueDescriptor createThreadField() {
        ArrayList<AnnotationElement> annos = new ArrayList();
        annos = TypeLibrary.createStandardAnnotations("Event Thread", "Thread in which event was committed in");
        return PrivateAccess.getInstance().newValueDescriptor("eventThread", Type.THREAD, annos, 0, true, "eventThread");
    }

    private static ValueDescriptor createDurationField() {
        List<Object> annos = new ArrayList();
        annos = TypeLibrary.createStandardAnnotations("Duration", null);
        annos.add(new AnnotationElement(Timespan.class, "TICKS"));
        return PrivateAccess.getInstance().newValueDescriptor("duration", Type.LONG, annos, 0, false, "duration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeLibrary getInstance() {
        Class<TypeLibrary> clazz = TypeLibrary.class;
        synchronized (TypeLibrary.class) {
            if (instance == null) {
                List<Type> jvmTypes;
                try {
                    jvmTypes = MetadataHandler.createTypes();
                    Collections.sort(jvmTypes, (a, b) -> Long.compare(a.getId(), b.getId()));
                }
                catch (IOException e) {
                    throw new Error("JFR: Could not read metadata");
                }
                instance = new TypeLibrary(jvmTypes);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public List<Type> getTypes() {
        return new ArrayList<Type>(types.values());
    }

    public static Type createAnnotationType(Class<? extends Annotation> a) {
        if (TypeLibrary.shouldPersist(a)) {
            Type type = TypeLibrary.defineType(a, Type.SUPER_TYPE_ANNOTATION, false);
            if (type != null) {
                SecuritySupport.makeVisibleToJFR(a);
                for (Method method : a.getDeclaredMethods()) {
                    type.add(PrivateAccess.getInstance().newValueDescriptor(method.getReturnType(), method.getName()));
                }
                ArrayList<AnnotationElement> aes = new ArrayList<AnnotationElement>();
                for (Annotation annotation : TypeLibrary.resolveRepeatedAnnotations(a.getAnnotations())) {
                    AnnotationElement ae = TypeLibrary.createAnnotation(annotation);
                    if (ae == null) continue;
                    aes.add(ae);
                }
                aes.trimToSize();
                type.setAnnotations(aes);
            }
            return TypeLibrary.getType(a);
        }
        return null;
    }

    static AnnotationElement createAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        Type type = TypeLibrary.createAnnotationType(annotationType);
        if (type != null) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (ValueDescriptor v : type.getFields()) {
                values.add(TypeLibrary.invokeAnnotation(annotation, v.getName()));
            }
            return PrivateAccess.getInstance().newAnnotation(type, values, annotation.annotationType().getClassLoader() == null);
        }
        return null;
    }

    private static Object invokeAnnotation(Annotation annotation, String methodName) {
        Method m;
        try {
            m = annotation.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e1) {
            throw new InternalError("Could not loacate method " + methodName + " in annotation " + annotation.getClass().getName());
        }
        SecuritySupport.setAccessible(m);
        try {
            return m.invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new InternalError("Could not get value for method " + methodName + " in annotation " + annotation.getClass().getName());
        }
    }

    private static boolean shouldPersist(Class<? extends Annotation> a) {
        return a != MetadataDefinition.class && a.getAnnotation(MetadataDefinition.class) != null;
    }

    private static boolean isDefined(Class<?> clazz) {
        return types.containsKey(Type.getTypeId(clazz));
    }

    private static Type getType(Class<?> clazz) {
        return types.get(Type.getTypeId(clazz));
    }

    private static Type defineType(Class<?> clazz, String superType, boolean eventType) {
        if (!TypeLibrary.isDefined(clazz)) {
            Name name = clazz.getAnnotation(Name.class);
            String typeName = name != null ? name.value() : clazz.getName();
            long id = Type.getTypeId(clazz);
            Type t = eventType ? new PlatformEventType(typeName, id, clazz.getClassLoader() == null, true) : new Type(typeName, superType, id);
            types.put(t.getId(), t);
            return t;
        }
        return null;
    }

    public static Type createType(Class<?> clazz) {
        return TypeLibrary.createType(clazz, Collections.emptyList(), Collections.emptyList());
    }

    public static Type createType(Class<?> clazz, List<AnnotationElement> dynamicAnnotations, List<ValueDescriptor> dynamicFields) {
        if (Thread.class == clazz) {
            return Type.THREAD;
        }
        if (Class.class.isAssignableFrom(clazz)) {
            return Type.CLASS;
        }
        if (String.class.equals(clazz)) {
            return Type.STRING;
        }
        if (TypeLibrary.isDefined(clazz)) {
            return TypeLibrary.getType(clazz);
        }
        if (clazz.isPrimitive()) {
            return TypeLibrary.defineType(clazz, null, false);
        }
        if (clazz.isArray()) {
            throw new InternalError("Arrays not supported");
        }
        String superType = null;
        boolean eventType = false;
        if (Event.class.isAssignableFrom(clazz)) {
            superType = Type.SUPER_TYPE_EVENT;
            eventType = true;
        }
        if (Control.class.isAssignableFrom(clazz)) {
            superType = Type.SUPER_TYPE_SETTING;
        }
        TypeLibrary.defineType(clazz, superType, eventType);
        Type type = TypeLibrary.getType(clazz);
        if (eventType) {
            TypeLibrary.addImplicitFields(type, true, true, true, true, false);
            TypeLibrary.addUserFields(clazz, type, dynamicFields);
            type.trimFields();
        }
        TypeLibrary.addAnnotations(clazz, type, dynamicAnnotations);
        if (clazz.getClassLoader() == null) {
            type.log("Added", LogTag.JFR_SYSTEM_METADATA, LogLevel.INFO);
        } else {
            type.log("Added", LogTag.JFR_METADATA, LogLevel.INFO);
        }
        return type;
    }

    private static void addAnnotations(Class<?> clazz, Type type, List<AnnotationElement> dynamicAnnotations) {
        ArrayList<AnnotationElement> aes = new ArrayList<AnnotationElement>();
        if (dynamicAnnotations.isEmpty()) {
            for (Annotation a : Utils.getAnnotations(clazz)) {
                AnnotationElement ae = TypeLibrary.createAnnotation(a);
                if (ae == null) continue;
                aes.add(ae);
            }
        } else {
            ArrayList<Type> newTypes = new ArrayList<Type>();
            aes.addAll(dynamicAnnotations);
            for (AnnotationElement ae : dynamicAnnotations) {
                newTypes.add(PrivateAccess.getInstance().getType(ae));
            }
            TypeLibrary.addTypes(newTypes);
        }
        type.setAnnotations(aes);
        aes.trimToSize();
    }

    private static void addUserFields(Class<?> clazz, Type type, List<ValueDescriptor> dynamicFields) {
        HashMap<String, ValueDescriptor> dynamicFieldSet = new HashMap<String, ValueDescriptor>();
        for (ValueDescriptor dynamicField : dynamicFields) {
            dynamicFieldSet.put(dynamicField.getName(), dynamicField);
        }
        ArrayList<Type> newTypes = new ArrayList<Type>();
        for (Field field : Utils.getVisibleEventFields(clazz)) {
            ValueDescriptor vd = (ValueDescriptor)dynamicFieldSet.get(field.getName());
            if (vd != null) {
                if (!vd.getTypeName().equals(field.getType().getName())) {
                    throw new InternalError("Type expected to match for field " + vd.getName() + " expected " + field.getName() + " but got " + vd.getName());
                }
                for (AnnotationElement ae : vd.getAnnotationElements()) {
                    newTypes.add(PrivateAccess.getInstance().getType(ae));
                }
                newTypes.add(PrivateAccess.getInstance().getType(vd));
            } else {
                vd = TypeLibrary.createField(field);
            }
            if (vd == null) continue;
            type.add(vd);
        }
        TypeLibrary.addTypes(newTypes);
    }

    static void addImplicitFields(Type type, boolean requestable, boolean hasDuration, boolean hasThread, boolean hasStackTrace, boolean hasCutoff) {
        TypeLibrary.createAnnotationType(Timespan.class);
        TypeLibrary.createAnnotationType(Timestamp.class);
        TypeLibrary.createAnnotationType(Label.class);
        TypeLibrary.defineType(Long.TYPE, null, false);
        TypeLibrary.addFields(type, requestable, hasDuration, hasThread, hasStackTrace, hasCutoff);
    }

    private static void addFields(Type type, boolean requestable, boolean hasDuration, boolean hasThread, boolean hasStackTrace, boolean hasCutoff) {
        type.add(START_TIME_FIELD);
        if (hasDuration || hasCutoff) {
            type.add(DURATION_FIELD);
        }
        if (hasThread) {
            type.add(THREAD_FIELD);
        }
        if (hasStackTrace) {
            type.add(STACK_TRACE_FIELD);
        }
    }

    private static List<AnnotationElement> createStandardAnnotations(String name, String description) {
        ArrayList<AnnotationElement> annotationElements = new ArrayList<AnnotationElement>(2);
        annotationElements.add(new AnnotationElement(Label.class, name));
        if (description != null) {
            annotationElements.add(new AnnotationElement(Description.class, description));
        }
        return annotationElements;
    }

    private static ValueDescriptor createField(Field field) {
        int mod = field.getModifiers();
        if (Modifier.isTransient(mod)) {
            return null;
        }
        if (Modifier.isStatic(mod)) {
            return null;
        }
        Class<?> fieldType = field.getType();
        if (!Type.isKnownType(fieldType)) {
            return null;
        }
        boolean constantPool = Thread.class == fieldType || fieldType == Class.class;
        Type type = TypeLibrary.createType(fieldType);
        String fieldName = field.getName();
        Name name = field.getAnnotation(Name.class);
        String useName = fieldName;
        if (name != null) {
            useName = name.value();
        }
        ArrayList<AnnotationElement> ans = new ArrayList<AnnotationElement>();
        for (Annotation a : TypeLibrary.resolveRepeatedAnnotations(field.getAnnotations())) {
            AnnotationElement ae = TypeLibrary.createAnnotation(a);
            if (ae == null) continue;
            ans.add(ae);
        }
        return PrivateAccess.getInstance().newValueDescriptor(useName, type, ans, 0, constantPool, fieldName);
    }

    private static List<Annotation> resolveRepeatedAnnotations(Annotation[] annotations) {
        ArrayList<Annotation> annos = new ArrayList<Annotation>(annotations.length);
        for (Annotation a : annotations) {
            boolean repeated = false;
            try {
                Object res;
                Class<?> ct;
                Method m = a.annotationType().getMethod("value", new Class[0]);
                Class<?> returnType = m.getReturnType();
                if (returnType.isArray() && Annotation.class.isAssignableFrom(ct = returnType.getComponentType()) && ct.getAnnotation(Repeatable.class) != null && (res = m.invoke((Object)a, new Object[0])) != null && Annotation[].class.isAssignableFrom(res.getClass())) {
                    for (Annotation rep : (Annotation[])m.invoke((Object)a, new Object[0])) {
                        annos.add(rep);
                    }
                    repeated = true;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
            if (repeated) continue;
            annos.add(a);
        }
        return annos;
    }

    public boolean clearUnregistered() {
        Logger.log(LogTag.JFR_METADATA, LogLevel.TRACE, "Cleaning out obsolete metadata");
        ArrayList<Type> registered = new ArrayList<Type>();
        for (Type type : types.values()) {
            if (!(type instanceof PlatformEventType) || !((PlatformEventType)type).isRegistered()) continue;
            registered.add(type);
        }
        TypeLibrary.visitReachable(registered, t -> t.getRemove(), t -> t.setRemove(false));
        ArrayList<Long> removeIds = new ArrayList<Long>();
        for (Type type : types.values()) {
            if (type.getRemove() && !Type.isDefinedByJVM(type.getId())) {
                removeIds.add(type.getId());
                if (Logger.shouldLog(LogTag.JFR_METADATA, LogLevel.TRACE)) {
                    Logger.log(LogTag.JFR_METADATA, LogLevel.TRACE, "Removed obsolete metadata " + type.getName());
                }
            }
            type.setRemove(true);
        }
        for (Long id : removeIds) {
            types.remove(id);
        }
        return !removeIds.isEmpty();
    }

    public void addType(Type type) {
        TypeLibrary.addTypes(Collections.singletonList(type));
    }

    public static void addTypes(List<Type> ts) {
        if (!ts.isEmpty()) {
            TypeLibrary.visitReachable(ts, t -> !types.containsKey(t.getId()), t -> types.put(t.getId(), (Type)t));
        }
    }

    private static void visitReachable(Collection<Type> rootSet, Predicate<Type> p, Consumer<Type> c) {
        ArrayDeque<Type> typeQ = new ArrayDeque<Type>(rootSet);
        while (!typeQ.isEmpty()) {
            Type type = (Type)typeQ.poll();
            if (!p.test(type)) continue;
            c.accept(type);
            TypeLibrary.visitAnnotations(typeQ, type.getAnnotationElements());
            for (ValueDescriptor v : type.getFields()) {
                typeQ.add(PrivateAccess.getInstance().getType(v));
                TypeLibrary.visitAnnotations(typeQ, v.getAnnotationElements());
            }
            if (!(type instanceof PlatformEventType)) continue;
            PlatformEventType pe = (PlatformEventType)type;
            for (SettingDescriptor s : pe.getAllSettings()) {
                typeQ.add(PrivateAccess.getInstance().getType(s));
                TypeLibrary.visitAnnotations(typeQ, s.getAnnotationElements());
            }
        }
    }

    private static void visitAnnotations(Queue<Type> typeQ, List<AnnotationElement> aes) {
        ArrayDeque<AnnotationElement> aQ = new ArrayDeque<AnnotationElement>(aes);
        HashSet<AnnotationElement> visited = new HashSet<AnnotationElement>();
        while (!aQ.isEmpty()) {
            AnnotationElement ae = (AnnotationElement)aQ.poll();
            if (!visited.contains(ae)) {
                Type ty = PrivateAccess.getInstance().getType(ae);
                typeQ.add(ty);
                visited.add(ae);
            }
            aQ.addAll(ae.getAnnotationElements());
        }
    }

    static {
        types = new LinkedHashMap<Long, Type>(100);
        DURATION_FIELD = TypeLibrary.createDurationField();
        THREAD_FIELD = TypeLibrary.createThreadField();
        STACK_TRACE_FIELD = TypeLibrary.createStackTraceField();
        START_TIME_FIELD = TypeLibrary.createStartTimeField();
    }
}

