/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.tool;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import jdk.jfr.EventType;
import jdk.jfr.Timespan;
import jdk.jfr.Timestamp;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedObject;
import jdk.jfr.consumer.RecordingFile;
import jdk.jfr.internal.consumer.RecordingInternals;
import jdk.jfr.internal.tool.StructuredWriter;

abstract class EventPrintWriter
extends StructuredWriter {
    protected static final String STACK_TRACE_FIELD = "stackTrace";
    protected static final String EVENT_THREAD_FIELD = "eventThread";
    private Predicate<EventType> eventFilter = x -> true;
    private int stackDepth;
    private Map<ValueDescriptor, ValueType> typeOfValues = new HashMap<ValueDescriptor, ValueType>();

    EventPrintWriter(PrintWriter p) {
        super(p);
    }

    protected abstract void print(List<RecordedEvent> var1);

    void print(Path source) throws FileNotFoundException, IOException {
        ArrayList<RecordedEvent> events = new ArrayList<RecordedEvent>(500000);
        this.printBegin();
        try (RecordingFile file = new RecordingFile(source);){
            while (file.hasMoreEvents()) {
                RecordedEvent event = file.readEvent();
                if (this.acceptEvent(event)) {
                    events.add(event);
                }
                if (!RecordingInternals.INSTANCE.isLastEventInChunk(file)) continue;
                RecordingInternals.INSTANCE.sort(events);
                this.print(events);
                events.clear();
            }
        }
        this.printEnd();
        this.flush(true);
    }

    protected void printEnd() {
    }

    protected void printBegin() {
    }

    public final void setEventFilter(Predicate<EventType> eventFilter) {
        this.eventFilter = eventFilter;
    }

    protected final boolean acceptEvent(RecordedEvent event) {
        return this.eventFilter.test(event.getEventType());
    }

    protected final int getStackDepth() {
        return this.stackDepth;
    }

    protected final boolean isLateField(String name) {
        return name.equals(EVENT_THREAD_FIELD) || name.equals(STACK_TRACE_FIELD);
    }

    public void setStackDepth(int stackDepth) {
        this.stackDepth = stackDepth;
    }

    protected Object getValue(RecordedObject object, ValueDescriptor v) {
        ValueType valueType = this.typeOfValues.get(v);
        if (valueType == null) {
            valueType = this.determineValueType(v);
            this.typeOfValues.put(v, valueType);
        }
        switch (valueType) {
            case TIMESPAN: {
                return object.getDuration(v.getName());
            }
            case TIMESTAMP: {
                return RecordingInternals.INSTANCE.getOffsetDataTime(object, v.getName());
            }
        }
        return object.getValue(v.getName());
    }

    private ValueType determineValueType(ValueDescriptor v) {
        if (v.getAnnotation(Timespan.class) != null) {
            return ValueType.TIMESPAN;
        }
        if (v.getAnnotation(Timestamp.class) != null) {
            return ValueType.TIMESTAMP;
        }
        return ValueType.OTHER;
    }

    static enum ValueType {
        TIMESPAN,
        TIMESTAMP,
        OTHER;

    }
}

