/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.tool;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import jdk.jfr.consumer.RecordingFile;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.consumer.RecordingInternals;
import jdk.jfr.internal.tool.Command;
import jdk.jfr.internal.tool.PrettyWriter;
import jdk.jfr.internal.tool.UserDataException;
import jdk.jfr.internal.tool.UserSyntaxException;

final class Metadata
extends Command {
    Metadata() {
    }

    @Override
    public String getName() {
        return "metadata";
    }

    @Override
    public List<String> getOptionSyntax() {
        return Collections.singletonList("<file>");
    }

    @Override
    public String getDescription() {
        return "Display event metadata, such as labels, descriptions and field layout";
    }

    @Override
    public void execute(Deque<String> options) throws UserSyntaxException, UserDataException {
        Path file = this.getJFRInputFile(options);
        boolean showIds = false;
        int optionCount = options.size();
        while (optionCount > 0) {
            if (this.acceptOption(options, "--ids")) {
                showIds = true;
            }
            if (optionCount == options.size()) {
                throw new UserSyntaxException("unknown option " + options.peek());
            }
            optionCount = options.size();
        }
        try (PrintWriter pw = new PrintWriter(System.out);){
            PrettyWriter prettyWriter = new PrettyWriter(pw);
            prettyWriter.setShowIds(showIds);
            try (RecordingFile rf = new RecordingFile(file);){
                List<Type> types = RecordingInternals.INSTANCE.readTypes(rf);
                Collections.sort(types, new TypeComparator());
                for (Type type : types) {
                    prettyWriter.printType(type);
                }
                prettyWriter.flush(true);
            }
            catch (IOException ioe) {
                this.couldNotReadError(file, ioe);
            }
        }
    }

    private static class TypeComparator
    implements Comparator<Type> {
        private TypeComparator() {
        }

        @Override
        public int compare(Type t1, Type t2) {
            int g2;
            int g1 = this.groupValue(t1);
            if (g1 == (g2 = this.groupValue(t2))) {
                String package2;
                String n1 = t1.getName();
                String n2 = t2.getName();
                String package1 = n1.substring(0, n1.lastIndexOf(46) + 1);
                if (package1.equals(package2 = n2.substring(0, n2.lastIndexOf(46) + 1))) {
                    return n1.compareTo(n2);
                }
                if (Type.SUPER_TYPE_EVENT.equals(t1.getSuperType()) && !package1.equals(package2)) {
                    if (package1.equals("jdk.jfr")) {
                        return -1;
                    }
                    if (package2.equals("jdk.jfr")) {
                        return 1;
                    }
                }
                return package1.compareTo(package2);
            }
            return Integer.compare(this.groupValue(t1), this.groupValue(t2));
        }

        int groupValue(Type t) {
            String superType = t.getSuperType();
            if (superType == null) {
                return 1;
            }
            if (Type.SUPER_TYPE_ANNOTATION.equals(superType)) {
                return 3;
            }
            if (Type.SUPER_TYPE_SETTING.equals(superType)) {
                return 4;
            }
            if (Type.SUPER_TYPE_EVENT.equals(superType)) {
                return 5;
            }
            return 2;
        }
    }
}

