/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import sun.security.ssl.Alert;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.Ciphertext;
import sun.security.ssl.ClientAuthType;
import sun.security.ssl.ContentType;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeHash;
import sun.security.ssl.Plaintext;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLEngineInputRecord;
import sun.security.ssl.SSLEngineOutputRecord;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLTransport;
import sun.security.ssl.TransportContext;
import sun.security.ssl.Utilities;

final class SSLEngineImpl
extends SSLEngine
implements SSLTransport {
    private final SSLContextImpl sslContext;
    final TransportContext conContext;

    SSLEngineImpl(SSLContextImpl sslContext) {
        this(sslContext, null, -1);
    }

    SSLEngineImpl(SSLContextImpl sslContext, String host, int port) {
        super(host, port);
        this.sslContext = sslContext;
        HandshakeHash handshakeHash = new HandshakeHash();
        this.conContext = new TransportContext(sslContext, this, new SSLEngineInputRecord(handshakeHash), new SSLEngineOutputRecord(handshakeHash));
        if (host != null) {
            this.conContext.sslConfig.serverNames = Utilities.addToSNIServerNameList(this.conContext.sslConfig.serverNames, host);
        }
    }

    @Override
    public synchronized void beginHandshake() throws SSLException {
        if (this.conContext.isUnsureMode) {
            throw new IllegalStateException("Client/Server mode has not yet been set.");
        }
        try {
            this.conContext.kickstart();
        }
        catch (IOException ioe) {
            throw this.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Couldn't kickstart handshaking", ioe);
        }
        catch (Exception ex) {
            throw this.conContext.fatal(Alert.INTERNAL_ERROR, "Fail to begin handshake", ex);
        }
    }

    @Override
    public synchronized SSLEngineResult wrap(ByteBuffer[] appData, int offset, int length, ByteBuffer netData) throws SSLException {
        return this.wrap(appData, offset, length, new ByteBuffer[]{netData}, 0, 1);
    }

    public synchronized SSLEngineResult wrap(ByteBuffer[] srcs, int srcsOffset, int srcsLength, ByteBuffer[] dsts, int dstsOffset, int dstsLength) throws SSLException {
        if (this.conContext.isUnsureMode) {
            throw new IllegalStateException("Client/Server mode has not yet been set.");
        }
        this.checkTaskThrown();
        SSLEngineImpl.checkParams(srcs, srcsOffset, srcsLength, dsts, dstsOffset, dstsLength);
        try {
            return this.writeRecord(srcs, srcsOffset, srcsLength, dsts, dstsOffset, dstsLength);
        }
        catch (SSLProtocolException spe) {
            throw this.conContext.fatal(Alert.UNEXPECTED_MESSAGE, spe);
        }
        catch (IOException ioe) {
            throw this.conContext.fatal(Alert.INTERNAL_ERROR, "problem wrapping app data", ioe);
        }
        catch (Exception ex) {
            throw this.conContext.fatal(Alert.INTERNAL_ERROR, "Fail to wrap application data", ex);
        }
    }

    private SSLEngineResult writeRecord(ByteBuffer[] srcs, int srcsOffset, int srcsLength, ByteBuffer[] dsts, int dstsOffset, int dstsLength) throws IOException {
        SSLEngineResult.Status status;
        if (this.isOutboundDone()) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, this.getHandshakeStatus(), 0, 0);
        }
        HandshakeContext hc = this.conContext.handshakeContext;
        SSLEngineResult.HandshakeStatus hsStatus = null;
        if (!(this.conContext.isNegotiated || this.conContext.isBroken || this.conContext.isInboundClosed() || this.conContext.isOutboundClosed())) {
            this.conContext.kickstart();
            hsStatus = this.getHandshakeStatus();
            if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                return new SSLEngineResult(SSLEngineResult.Status.OK, hsStatus, 0, 0);
            }
        }
        if (hsStatus == null) {
            hsStatus = this.getHandshakeStatus();
        }
        if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            return new SSLEngineResult(SSLEngineResult.Status.OK, hsStatus, 0, 0);
        }
        int dstsRemains = 0;
        for (int i = dstsOffset; i < dstsOffset + dstsLength; ++i) {
            dstsRemains += dsts[i].remaining();
        }
        if (dstsRemains < this.conContext.conSession.getPacketBufferSize()) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatus(), 0, 0);
        }
        int srcsRemains = 0;
        for (int i = srcsOffset; i < srcsOffset + srcsLength; ++i) {
            srcsRemains += srcs[i].remaining();
        }
        Ciphertext ciphertext = null;
        try {
            if (!this.conContext.outputRecord.isEmpty()) {
                ciphertext = this.encode(null, 0, 0, dsts, dstsOffset, dstsLength);
            }
            if (ciphertext == null && srcsRemains != 0) {
                ciphertext = this.encode(srcs, srcsOffset, srcsLength, dsts, dstsOffset, dstsLength);
            }
        }
        catch (IOException ioe) {
            if (ioe instanceof SSLException) {
                throw ioe;
            }
            throw new SSLException("Write problems", ioe);
        }
        SSLEngineResult.Status status2 = status = this.isOutboundDone() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK;
        if (ciphertext != null && ciphertext.handshakeStatus != null) {
            hsStatus = ciphertext.handshakeStatus;
        } else {
            hsStatus = this.getHandshakeStatus();
            if (ciphertext == null && !this.conContext.isNegotiated && this.conContext.isInboundClosed() && hsStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                status = SSLEngineResult.Status.CLOSED;
            }
        }
        int deltaSrcs = srcsRemains;
        for (int i = srcsOffset; i < srcsOffset + srcsLength; ++i) {
            deltaSrcs -= srcs[i].remaining();
        }
        int deltaDsts = dstsRemains;
        for (int i = dstsOffset; i < dstsOffset + dstsLength; ++i) {
            deltaDsts -= dsts[i].remaining();
        }
        return new SSLEngineResult(status, hsStatus, deltaSrcs, deltaDsts);
    }

    private Ciphertext encode(ByteBuffer[] srcs, int srcsOffset, int srcsLength, ByteBuffer[] dsts, int dstsOffset, int dstsLength) throws IOException {
        Ciphertext ciphertext = null;
        try {
            ciphertext = this.conContext.outputRecord.encode(srcs, srcsOffset, srcsLength, dsts, dstsOffset, dstsLength);
        }
        catch (SSLHandshakeException she) {
            throw this.conContext.fatal(Alert.HANDSHAKE_FAILURE, she);
        }
        catch (IOException e) {
            throw this.conContext.fatal(Alert.UNEXPECTED_MESSAGE, e);
        }
        if (ciphertext == null) {
            return null;
        }
        SSLEngineResult.HandshakeStatus hsStatus = this.tryToFinishHandshake(ciphertext.contentType);
        if (hsStatus == null) {
            hsStatus = this.conContext.getHandshakeStatus();
        }
        if (this.conContext.outputRecord.seqNumIsHuge() || this.conContext.outputRecord.writeCipher.atKeyLimit()) {
            hsStatus = this.tryKeyUpdate(hsStatus);
        }
        ciphertext.handshakeStatus = hsStatus;
        return ciphertext;
    }

    private SSLEngineResult.HandshakeStatus tryToFinishHandshake(byte contentType) {
        SSLEngineResult.HandshakeStatus hsStatus = null;
        if (contentType == ContentType.HANDSHAKE.id && this.conContext.outputRecord.isEmpty()) {
            if (this.conContext.handshakeContext == null) {
                hsStatus = SSLEngineResult.HandshakeStatus.FINISHED;
            } else if (this.conContext.isPostHandshakeContext()) {
                hsStatus = this.conContext.finishPostHandshake();
            } else if (this.conContext.handshakeContext.handshakeFinished) {
                hsStatus = this.conContext.finishHandshake();
            }
        }
        return hsStatus;
    }

    private SSLEngineResult.HandshakeStatus tryKeyUpdate(SSLEngineResult.HandshakeStatus currentHandshakeStatus) throws IOException {
        if (this.conContext.handshakeContext == null && !this.conContext.isOutboundClosed() && !this.conContext.isBroken) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.finest("trigger key update", new Object[0]);
            }
            this.beginHandshake();
            return this.conContext.getHandshakeStatus();
        }
        return currentHandshakeStatus;
    }

    private static void checkParams(ByteBuffer[] srcs, int srcsOffset, int srcsLength, ByteBuffer[] dsts, int dstsOffset, int dstsLength) {
        int i;
        if (srcs == null || dsts == null) {
            throw new IllegalArgumentException("source or destination buffer is null");
        }
        if (dstsOffset < 0 || dstsLength < 0 || dstsOffset > dsts.length - dstsLength) {
            throw new IndexOutOfBoundsException("index out of bound of the destination buffers");
        }
        if (srcsOffset < 0 || srcsLength < 0 || srcsOffset > srcs.length - srcsLength) {
            throw new IndexOutOfBoundsException("index out of bound of the source buffers");
        }
        for (i = dstsOffset; i < dstsOffset + dstsLength; ++i) {
            if (dsts[i] == null) {
                throw new IllegalArgumentException("destination buffer[" + i + "] == null");
            }
            if (!dsts[i].isReadOnly()) continue;
            throw new ReadOnlyBufferException();
        }
        for (i = srcsOffset; i < srcsOffset + srcsLength; ++i) {
            if (srcs[i] != null) continue;
            throw new IllegalArgumentException("source buffer[" + i + "] == null");
        }
    }

    @Override
    public synchronized SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) throws SSLException {
        return this.unwrap(new ByteBuffer[]{src}, 0, 1, dsts, offset, length);
    }

    public synchronized SSLEngineResult unwrap(ByteBuffer[] srcs, int srcsOffset, int srcsLength, ByteBuffer[] dsts, int dstsOffset, int dstsLength) throws SSLException {
        if (this.conContext.isUnsureMode) {
            throw new IllegalStateException("Client/Server mode has not yet been set.");
        }
        this.checkTaskThrown();
        SSLEngineImpl.checkParams(srcs, srcsOffset, srcsLength, dsts, dstsOffset, dstsLength);
        try {
            return this.readRecord(srcs, srcsOffset, srcsLength, dsts, dstsOffset, dstsLength);
        }
        catch (SSLProtocolException spe) {
            throw this.conContext.fatal(Alert.UNEXPECTED_MESSAGE, spe.getMessage(), spe);
        }
        catch (IOException ioe) {
            throw this.conContext.fatal(Alert.INTERNAL_ERROR, "problem unwrapping net record", ioe);
        }
        catch (Exception ex) {
            throw this.conContext.fatal(Alert.INTERNAL_ERROR, "Fail to unwrap network record", ex);
        }
    }

    private SSLEngineResult readRecord(ByteBuffer[] srcs, int srcsOffset, int srcsLength, ByteBuffer[] dsts, int dstsOffset, int dstsLength) throws IOException {
        int FragLen;
        if (this.isInboundDone()) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, this.getHandshakeStatus(), 0, 0);
        }
        SSLEngineResult.HandshakeStatus hsStatus = null;
        if (!(this.conContext.isNegotiated || this.conContext.isBroken || this.conContext.isInboundClosed() || this.conContext.isOutboundClosed())) {
            this.conContext.kickstart();
            hsStatus = this.getHandshakeStatus();
            if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                return new SSLEngineResult(SSLEngineResult.Status.OK, hsStatus, 0, 0);
            }
        }
        if (hsStatus == null) {
            hsStatus = this.getHandshakeStatus();
        }
        if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            return new SSLEngineResult(SSLEngineResult.Status.OK, hsStatus, 0, 0);
        }
        int srcsRemains = 0;
        for (int i = srcsOffset; i < srcsOffset + srcsLength; ++i) {
            srcsRemains += srcs[i].remaining();
        }
        if (srcsRemains == 0) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_UNDERFLOW, hsStatus, 0, 0);
        }
        int packetLen = this.conContext.inputRecord.bytesInCompletePacket(srcs, srcsOffset, srcsLength);
        if (packetLen > this.conContext.conSession.getPacketBufferSize()) {
            int largestRecordSize = 33093;
            if (packetLen <= largestRecordSize) {
                this.conContext.conSession.expandBufferSizes();
            }
            if (packetLen > (largestRecordSize = this.conContext.conSession.getPacketBufferSize())) {
                throw new SSLProtocolException("Input record too big: max = " + largestRecordSize + " len = " + packetLen);
            }
        }
        int dstsRemains = 0;
        for (int i = dstsOffset; i < dstsOffset + dstsLength; ++i) {
            dstsRemains += dsts[i].remaining();
        }
        if (this.conContext.isNegotiated && (FragLen = this.conContext.inputRecord.estimateFragmentSize(packetLen)) > dstsRemains) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, hsStatus, 0, 0);
        }
        if (packetLen == -1 || srcsRemains < packetLen) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_UNDERFLOW, hsStatus, 0, 0);
        }
        Plaintext plainText = null;
        try {
            plainText = this.decode(srcs, srcsOffset, srcsLength, dsts, dstsOffset, dstsLength);
        }
        catch (IOException ioe) {
            if (ioe instanceof SSLException) {
                throw ioe;
            }
            throw new SSLException("readRecord", ioe);
        }
        SSLEngineResult.Status status = this.isInboundDone() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK;
        hsStatus = plainText.handshakeStatus != null ? plainText.handshakeStatus : this.getHandshakeStatus();
        int deltaNet = srcsRemains;
        for (int i = srcsOffset; i < srcsOffset + srcsLength; ++i) {
            deltaNet -= srcs[i].remaining();
        }
        int deltaApp = dstsRemains;
        for (int i = dstsOffset; i < dstsOffset + dstsLength; ++i) {
            deltaApp -= dsts[i].remaining();
        }
        return new SSLEngineResult(status, hsStatus, deltaNet, deltaApp);
    }

    private Plaintext decode(ByteBuffer[] srcs, int srcsOffset, int srcsLength, ByteBuffer[] dsts, int dstsOffset, int dstsLength) throws IOException {
        Plaintext pt = SSLTransport.decode(this.conContext, srcs, srcsOffset, srcsLength, dsts, dstsOffset, dstsLength);
        if (pt != Plaintext.PLAINTEXT_NULL) {
            SSLEngineResult.HandshakeStatus hsStatus = this.tryToFinishHandshake(pt.contentType);
            pt.handshakeStatus = hsStatus == null ? this.conContext.getHandshakeStatus() : hsStatus;
            if (this.conContext.inputRecord.seqNumIsHuge() || this.conContext.inputRecord.readCipher.atKeyLimit()) {
                pt.handshakeStatus = this.tryKeyUpdate(pt.handshakeStatus);
            }
        }
        return pt;
    }

    @Override
    public synchronized Runnable getDelegatedTask() {
        if (this.conContext.handshakeContext != null && !this.conContext.handshakeContext.taskDelegated && !this.conContext.handshakeContext.delegatedActions.isEmpty()) {
            this.conContext.handshakeContext.taskDelegated = true;
            return new DelegatedTask(this);
        }
        return null;
    }

    @Override
    public synchronized void closeInbound() throws SSLException {
        if (this.isInboundDone()) {
            return;
        }
        if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
            SSLLogger.finest("Closing inbound of SSLEngine", new Object[0]);
        }
        if (!this.conContext.isInputCloseNotified && (this.conContext.isNegotiated || this.conContext.handshakeContext != null)) {
            throw this.conContext.fatal(Alert.INTERNAL_ERROR, "closing inbound before receiving peer's close_notify");
        }
        this.conContext.closeInbound();
    }

    @Override
    public synchronized boolean isInboundDone() {
        return this.conContext.isInboundClosed();
    }

    @Override
    public synchronized void closeOutbound() {
        if (this.conContext.isOutboundClosed()) {
            return;
        }
        if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
            SSLLogger.finest("Closing outbound of SSLEngine", new Object[0]);
        }
        this.conContext.closeOutbound();
    }

    @Override
    public synchronized boolean isOutboundDone() {
        return this.conContext.isOutboundDone();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return CipherSuite.namesOf(this.sslContext.getSupportedCipherSuites());
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return CipherSuite.namesOf(this.conContext.sslConfig.enabledCipherSuites);
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] suites) {
        this.conContext.sslConfig.enabledCipherSuites = CipherSuite.validValuesOf(suites);
    }

    @Override
    public String[] getSupportedProtocols() {
        return ProtocolVersion.toStringArray(this.sslContext.getSupportedProtocolVersions());
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return ProtocolVersion.toStringArray(this.conContext.sslConfig.enabledProtocols);
    }

    @Override
    public synchronized void setEnabledProtocols(String[] protocols) {
        if (protocols == null) {
            throw new IllegalArgumentException("Protocols cannot be null");
        }
        this.conContext.sslConfig.enabledProtocols = ProtocolVersion.namesOf(protocols);
    }

    @Override
    public synchronized SSLSession getSession() {
        return this.conContext.conSession;
    }

    @Override
    public synchronized SSLSession getHandshakeSession() {
        return this.conContext.handshakeContext == null ? null : this.conContext.handshakeContext.handshakeSession;
    }

    @Override
    public synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this.conContext.getHandshakeStatus();
    }

    @Override
    public synchronized void setUseClientMode(boolean mode) {
        this.conContext.setUseClientMode(mode);
    }

    @Override
    public synchronized boolean getUseClientMode() {
        return this.conContext.sslConfig.isClientMode;
    }

    @Override
    public synchronized void setNeedClientAuth(boolean need) {
        this.conContext.sslConfig.clientAuthType = need ? ClientAuthType.CLIENT_AUTH_REQUIRED : ClientAuthType.CLIENT_AUTH_NONE;
    }

    @Override
    public synchronized boolean getNeedClientAuth() {
        return this.conContext.sslConfig.clientAuthType == ClientAuthType.CLIENT_AUTH_REQUIRED;
    }

    @Override
    public synchronized void setWantClientAuth(boolean want) {
        this.conContext.sslConfig.clientAuthType = want ? ClientAuthType.CLIENT_AUTH_REQUESTED : ClientAuthType.CLIENT_AUTH_NONE;
    }

    @Override
    public synchronized boolean getWantClientAuth() {
        return this.conContext.sslConfig.clientAuthType == ClientAuthType.CLIENT_AUTH_REQUESTED;
    }

    @Override
    public synchronized void setEnableSessionCreation(boolean flag) {
        this.conContext.sslConfig.enableSessionCreation = flag;
    }

    @Override
    public synchronized boolean getEnableSessionCreation() {
        return this.conContext.sslConfig.enableSessionCreation;
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        return this.conContext.sslConfig.getSSLParameters();
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters params) {
        this.conContext.sslConfig.setSSLParameters(params);
        if (this.conContext.sslConfig.maximumPacketSize != 0) {
            this.conContext.outputRecord.changePacketSize(this.conContext.sslConfig.maximumPacketSize);
        }
    }

    @Override
    public synchronized String getApplicationProtocol() {
        return this.conContext.applicationProtocol;
    }

    @Override
    public synchronized String getHandshakeApplicationProtocol() {
        return this.conContext.handshakeContext == null ? null : this.conContext.handshakeContext.applicationProtocol;
    }

    @Override
    public synchronized void setHandshakeApplicationProtocolSelector(BiFunction<SSLEngine, List<String>, String> selector) {
        this.conContext.sslConfig.engineAPSelector = selector;
    }

    @Override
    public synchronized BiFunction<SSLEngine, List<String>, String> getHandshakeApplicationProtocolSelector() {
        return this.conContext.sslConfig.engineAPSelector;
    }

    @Override
    public boolean useDelegatedTask() {
        return true;
    }

    private synchronized void checkTaskThrown() throws SSLException {
        Exception exc = null;
        HandshakeContext hc = this.conContext.handshakeContext;
        if (hc != null && hc.delegatedThrown != null) {
            exc = hc.delegatedThrown;
            hc.delegatedThrown = null;
        }
        if (this.conContext.delegatedThrown != null) {
            if (exc != null) {
                if (this.conContext.delegatedThrown == exc) {
                    this.conContext.delegatedThrown = null;
                }
            } else {
                exc = this.conContext.delegatedThrown;
                this.conContext.delegatedThrown = null;
            }
        }
        if (exc == null) {
            return;
        }
        if (exc instanceof SSLException) {
            throw (SSLException)exc;
        }
        if (exc instanceof RuntimeException) {
            throw (RuntimeException)exc;
        }
        throw SSLEngineImpl.getTaskThrown(exc);
    }

    private static SSLException getTaskThrown(Exception taskThrown) {
        String msg = taskThrown.getMessage();
        if (msg == null) {
            msg = "Delegated task threw Exception or Error";
        }
        if (taskThrown instanceof RuntimeException) {
            throw new RuntimeException(msg, taskThrown);
        }
        if (taskThrown instanceof SSLHandshakeException) {
            return (SSLHandshakeException)new SSLHandshakeException(msg).initCause(taskThrown);
        }
        if (taskThrown instanceof SSLKeyException) {
            return (SSLKeyException)new SSLKeyException(msg).initCause(taskThrown);
        }
        if (taskThrown instanceof SSLPeerUnverifiedException) {
            return (SSLPeerUnverifiedException)new SSLPeerUnverifiedException(msg).initCause(taskThrown);
        }
        if (taskThrown instanceof SSLProtocolException) {
            return (SSLProtocolException)new SSLProtocolException(msg).initCause(taskThrown);
        }
        if (taskThrown instanceof SSLException) {
            return (SSLException)taskThrown;
        }
        return new SSLException(msg, taskThrown);
    }

    private static class DelegatedTask
    implements Runnable {
        private final SSLEngineImpl engine;

        DelegatedTask(SSLEngineImpl engineInstance) {
            this.engine = engineInstance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SSLEngineImpl sSLEngineImpl = this.engine;
            synchronized (sSLEngineImpl) {
                HandshakeContext hc;
                block14: {
                    hc = this.engine.conContext.handshakeContext;
                    if (hc == null || hc.delegatedActions.isEmpty()) {
                        return;
                    }
                    try {
                        AccessController.doPrivileged(new DelegatedAction(hc), this.engine.conContext.acc);
                    }
                    catch (PrivilegedActionException pae) {
                        Exception reportedException = pae.getException();
                        if (this.engine.conContext.delegatedThrown == null) {
                            this.engine.conContext.delegatedThrown = reportedException;
                        }
                        if ((hc = this.engine.conContext.handshakeContext) != null) {
                            hc.delegatedThrown = reportedException;
                        } else if (this.engine.conContext.closeReason != null) {
                            this.engine.conContext.closeReason = SSLEngineImpl.getTaskThrown(reportedException);
                        }
                    }
                    catch (RuntimeException rte) {
                        if (this.engine.conContext.delegatedThrown == null) {
                            this.engine.conContext.delegatedThrown = rte;
                        }
                        if ((hc = this.engine.conContext.handshakeContext) != null) {
                            hc.delegatedThrown = rte;
                        }
                        if (this.engine.conContext.closeReason == null) break block14;
                        this.engine.conContext.closeReason = rte;
                    }
                }
                hc = this.engine.conContext.handshakeContext;
                if (hc != null) {
                    hc.taskDelegated = false;
                }
            }
        }

        private static class DelegatedAction
        implements PrivilegedExceptionAction<Void> {
            final HandshakeContext context;

            DelegatedAction(HandshakeContext context) {
                this.context = context;
            }

            @Override
            public Void run() throws Exception {
                while (!this.context.delegatedActions.isEmpty()) {
                    Map.Entry<Byte, ByteBuffer> me = this.context.delegatedActions.poll();
                    if (me == null) continue;
                    this.context.dispatch((byte)me.getKey(), me.getValue());
                }
                return null;
            }
        }
    }
}

