/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.locks;

import java.util.concurrent.ThreadLocalRandom;
import sun.misc.Unsafe;

public class LockSupport {
    private static final Unsafe UNSAFE;
    private static final long parkBlockerOffset;
    private static final long SEED;
    private static final long PROBE;
    private static final long SECONDARY;

    private LockSupport() {
    }

    private static void setBlocker(Thread t, Object arg) {
        UNSAFE.putObject((Object)t, parkBlockerOffset, arg);
    }

    public static void unpark(Thread thread) {
        if (thread != null) {
            UNSAFE.unpark(thread);
        }
    }

    public static void park(Object blocker) {
        Thread t = Thread.currentThread();
        LockSupport.setBlocker(t, blocker);
        UNSAFE.park(false, 0L);
        LockSupport.setBlocker(t, null);
    }

    public static void parkNanos(Object blocker, long nanos) {
        if (nanos > 0L) {
            Thread t = Thread.currentThread();
            LockSupport.setBlocker(t, blocker);
            UNSAFE.park(false, nanos);
            LockSupport.setBlocker(t, null);
        }
    }

    public static void parkUntil(Object blocker, long deadline) {
        Thread t = Thread.currentThread();
        LockSupport.setBlocker(t, blocker);
        UNSAFE.park(true, deadline);
        LockSupport.setBlocker(t, null);
    }

    public static Object getBlocker(Thread t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return UNSAFE.getObjectVolatile(t, parkBlockerOffset);
    }

    public static void park() {
        UNSAFE.park(false, 0L);
    }

    public static void parkNanos(long nanos) {
        if (nanos > 0L) {
            UNSAFE.park(false, nanos);
        }
    }

    public static void parkUntil(long deadline) {
        UNSAFE.park(true, deadline);
    }

    static final int nextSecondarySeed() {
        Thread t = Thread.currentThread();
        int r = UNSAFE.getInt((Object)t, SECONDARY);
        if (r != 0) {
            r ^= r << 13;
            r ^= r >>> 17;
            r ^= r << 5;
        } else {
            r = ThreadLocalRandom.current().nextInt();
            if (r == 0) {
                r = 1;
            }
        }
        UNSAFE.putInt((Object)t, SECONDARY, r);
        return r;
    }

    static {
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<Thread> tk = Thread.class;
            parkBlockerOffset = UNSAFE.objectFieldOffset(tk.getDeclaredField("parkBlocker"));
            SEED = UNSAFE.objectFieldOffset(tk.getDeclaredField("threadLocalRandomSeed"));
            PROBE = UNSAFE.objectFieldOffset(tk.getDeclaredField("threadLocalRandomProbe"));
            SECONDARY = UNSAFE.objectFieldOffset(tk.getDeclaredField("threadLocalRandomSecondarySeed"));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }
}

