/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import sun.java2d.xr.XRBackend;
import sun.java2d.xr.XRColor;
import sun.java2d.xr.XRCompositeManager;
import sun.java2d.xr.XRSurfaceData;

public class XRMaskImage {
    private static final int MASK_SCALE_FACTOR = 8;
    private static final int BLIT_MASK_SIZE = 8;
    Dimension blitMaskDimensions = new Dimension(8, 8);
    int blitMaskPixmap;
    int blitMaskPicture;
    int lastMaskWidth = 0;
    int lastMaskHeight = 0;
    int lastEA = -1;
    AffineTransform lastMaskTransform;
    XRCompositeManager xrMgr;
    XRBackend con;

    public XRMaskImage(XRCompositeManager xrMgr, int parentDrawable) {
        this.xrMgr = xrMgr;
        this.con = xrMgr.getBackend();
        this.initBlitMask(parentDrawable, 8, 8);
    }

    public int prepareBlitMask(XRSurfaceData dst, AffineTransform maskTX, int width, int height) {
        int maskWidth = Math.max(width / 8, 1);
        int maskHeight = Math.max(height / 8, 1);
        maskTX.scale((double)width / (double)maskWidth, (double)height / (double)maskHeight);
        try {
            maskTX.invert();
        }
        catch (NoninvertibleTransformException ex) {
            maskTX.setToIdentity();
        }
        this.ensureBlitMaskSize(maskWidth, maskHeight);
        if (this.lastMaskTransform == null || !this.lastMaskTransform.equals(maskTX)) {
            this.con.setPictureTransform(this.blitMaskPicture, maskTX);
            this.lastMaskTransform = maskTX;
        }
        int currentEA = this.xrMgr.getAlphaColor().getAlpha();
        if (this.lastMaskWidth != maskWidth || this.lastMaskHeight != maskHeight || this.lastEA != currentEA) {
            if (this.lastMaskWidth > maskWidth || this.lastMaskHeight > maskHeight) {
                this.con.renderRectangle(this.blitMaskPicture, (byte)0, XRColor.NO_ALPHA, 0, 0, this.lastMaskWidth, this.lastMaskHeight);
            }
            this.con.renderRectangle(this.blitMaskPicture, (byte)1, this.xrMgr.getAlphaColor(), 0, 0, maskWidth, maskHeight);
            this.lastEA = currentEA;
        }
        this.lastMaskWidth = maskWidth;
        this.lastMaskHeight = maskHeight;
        return this.blitMaskPicture;
    }

    private void initBlitMask(int parentDrawable, int width, int height) {
        int newPM = this.con.createPixmap(parentDrawable, 8, width, height);
        int newPict = this.con.createPicture(newPM, 2);
        if (this.blitMaskPixmap != 0) {
            this.con.freePixmap(this.blitMaskPixmap);
            this.con.freePicture(this.blitMaskPicture);
        }
        this.blitMaskPixmap = newPM;
        this.blitMaskPicture = newPict;
        this.con.renderRectangle(this.blitMaskPicture, (byte)0, XRColor.NO_ALPHA, 0, 0, width, height);
        this.blitMaskDimensions.width = width;
        this.blitMaskDimensions.height = height;
        this.lastMaskWidth = 0;
        this.lastMaskHeight = 0;
        this.lastMaskTransform = null;
    }

    private void ensureBlitMaskSize(int minSizeX, int minSizeY) {
        if (minSizeX > this.blitMaskDimensions.width || minSizeY > this.blitMaskDimensions.height) {
            int newWidth = Math.max(minSizeX, this.blitMaskDimensions.width);
            int newHeight = Math.max(minSizeY, this.blitMaskDimensions.height);
            this.initBlitMask(this.blitMaskPixmap, newWidth, newHeight);
        }
    }
}

