/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Checksum;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.util.KerberosString;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class PAForUserEnc {
    public final PrincipalName name;
    private final EncryptionKey key;
    public static final String AUTH_PACKAGE = "Kerberos";

    public PAForUserEnc(PrincipalName name, EncryptionKey key) {
        this.name = name;
        this.key = key;
    }

    public PAForUserEnc(DerValue encoding, EncryptionKey key) throws Asn1Exception, KrbException, IOException {
        DerValue der = null;
        this.key = key;
        if (encoding.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        PrincipalName tmpName = null;
        der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) == 0) {
            try {
                tmpName = new PrincipalName(der.getData().getDerValue(), new Realm("PLACEHOLDER"));
            }
            catch (RealmException realmException) {}
        } else {
            throw new Asn1Exception(906);
        }
        der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) == 1) {
            try {
                Realm realm = new Realm(der.getData().getDerValue());
                this.name = new PrincipalName(tmpName.getNameType(), tmpName.getNameStrings(), realm);
            }
            catch (RealmException re) {
                throw new IOException(re);
            }
        } else {
            throw new Asn1Exception(906);
        }
        der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) != 2) {
            throw new Asn1Exception(906);
        }
        der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) == 3) {
            String authPackage = new KerberosString(der.getData().getDerValue()).toString();
            if (!authPackage.equalsIgnoreCase(AUTH_PACKAGE)) {
                throw new IOException("Incorrect auth-package");
            }
        } else {
            throw new Asn1Exception(906);
        }
        if (encoding.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), this.name.asn1Encode());
        bytes.write(DerValue.createTag((byte)-128, true, (byte)1), this.name.getRealm().asn1Encode());
        try {
            Checksum cks = new Checksum(-138, this.getS4UByteArray(), this.key, 17);
            bytes.write(DerValue.createTag((byte)-128, true, (byte)2), cks.asn1Encode());
        }
        catch (KrbException ke) {
            throw new IOException(ke);
        }
        DerOutputStream temp = new DerOutputStream();
        temp.putDerValue(new KerberosString(AUTH_PACKAGE).toDerValue());
        bytes.write(DerValue.createTag((byte)-128, true, (byte)3), temp);
        temp = new DerOutputStream();
        temp.write((byte)48, bytes);
        return temp.toByteArray();
    }

    public byte[] getS4UByteArray() {
        try {
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            ba.write(new byte[4]);
            for (String s : this.name.getNameStrings()) {
                ba.write(s.getBytes("UTF-8"));
            }
            ba.write(this.name.getRealm().toString().getBytes("UTF-8"));
            ba.write(AUTH_PACKAGE.getBytes("UTF-8"));
            byte[] output = ba.toByteArray();
            int pnType = this.name.getNameType();
            output[0] = (byte)(pnType & 0xFF);
            output[1] = (byte)(pnType >> 8 & 0xFF);
            output[2] = (byte)(pnType >> 16 & 0xFF);
            output[3] = (byte)(pnType >> 24 & 0xFF);
            return output;
        }
        catch (IOException ioe) {
            throw new AssertionError("Cannot write ByteArrayOutputStream", ioe);
        }
    }

    public PrincipalName getName() {
        return this.name;
    }

    public String toString() {
        return "PA-FOR-USER: " + this.name;
    }
}

