/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import sun.security.util.Debug;
import sun.security.x509.X509CertImpl;

public final class UntrustedCertificates {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final String ALGORITHM_KEY = "Algorithm";
    private static final Properties props = new Properties();
    private static final String algorithm;

    public static boolean isUntrusted(X509Certificate cert) {
        String key;
        if (algorithm == null) {
            return false;
        }
        if (cert instanceof X509CertImpl) {
            key = ((X509CertImpl)cert).getFingerprint(algorithm);
        } else {
            try {
                key = new X509CertImpl(cert.getEncoded()).getFingerprint(algorithm);
            }
            catch (CertificateException cee) {
                return false;
            }
        }
        return props.containsKey(key);
    }

    private UntrustedCertificates() {
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                block14: {
                    File f = new File(System.getProperty("java.home"), "lib/security/blacklisted.certs");
                    try (FileInputStream fin = new FileInputStream(f);){
                        props.load(fin);
                    }
                    catch (IOException fnfe) {
                        if (debug == null) break block14;
                        debug.println("Error parsing blacklisted.certs");
                    }
                }
                return null;
            }
        });
        algorithm = props.getProperty(ALGORITHM_KEY);
    }
}

