<?php

namespace Adfox\Appearance\Filament\Pages;

use App\Filament\Clusters\DesignAppearance;
use App\Settings\AppearanceSettings;
use App\Settings\ThemeSettings;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\ViewField;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use Illuminate\Contracts\Support\Htmlable;

class ManageTheme extends SettingsPage
{
    use HasPageShield;

    protected static ?string $cluster = DesignAppearance::class;
    protected static ?int $navigationSort = 1;
    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public function getTitle(): string|Htmlable
    {
        return __('messages.t_ap_theme');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_ap_theme');
    }

    protected static string $settings = ThemeSettings::class;

    public ?array $data = [];

    public static function canAccess(): bool
    {
        return userHasPermission('page_ManageTheme');
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                ViewField::make('selected_theme')
                    ->columnSpanFull()
                    ->view('appearance::filament.fields.theme'),
            ])
            ->statePath('data');
    }
}
