<?php

namespace Adfox\Appearance\Filament\Pages;

use App\Filament\Clusters\DesignAppearance;
use App\Settings\UiCustomizationSettings;
use Filament\Forms\Components\Fieldset;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Forms\Get;
use Filament\Forms\Set;
use Filament\Pages\SettingsPage;

class UiCustomizationPage extends SettingsPage
{
    protected static string $settings = UiCustomizationSettings::class;

    protected static ?string $cluster = DesignAppearance::class;

    protected static ?string $navigationIcon = 'heroicon-o-document-magnifying-glass';

    public static function getNavigationLabel(): string
    {
        return __('messages.t_ap_ad_detail_settings');
    }

    public function getTitle(): string
    {
        return __('messages.t_ap_ad_detail_settings');
    }
    public static function canAccess(): bool
    {
        return userHasPermission('page_UiCustomizationPage');
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make()
                    // ->description('Customize the order of the ad detail page sections.')
                    ->schema([
                        Repeater::make('ad_detail_page')
                            ->addable(false)
                            ->deletable(false)
                            ->schema([
                                Fieldset::make(__('messages.t_title_section'))->schema([
                                    Toggle::make('enable_location_below_title')
                                        ->label(__('messages.t_enable_location_below_title_label'))
                                        ->helperText(__('messages.t_enable_location_below_title_helper')),
                                    Toggle::make('enable_mobile_view_ad_action_in_below_ad')
                                        ->label(__('messages.t_enable_mobile_view_ad_action_in_below_ad'))
                                        ->helperText(__('messages.t_enable_mobile_view_ad_action_in_below_ad_helpertext'))
                                        ->visible(fn(Get $get) => $get('enable_carousel')),
                                ]),
                                Fieldset::make(__('messages.t_ad_image'))->schema([
                                    Toggle::make('enable_carousel')
                                        ->label(__('messages.t_enable_carousel_label'))
                                        ->helperText(__('messages.t_enable_carousel_helper'))
                                        ->live(onBlur: true)
                                        ->afterStateUpdated(function (Set $set, $state) {
                                            if (!$state) {
                                                $set('enable_price_below_image', false);
                                                $set('enable_favourite_move_to_ad_action', false);
                                                $set('enable_pagination_count', false);
                                                $set('enable_autoplay', false);
                                                $set('autoplay_interval', null);
                                            }
                                        }),
                                    Toggle::make('enable_price_below_image')
                                        ->label(__('messages.t_enable_price_below_image_label'))
                                        ->helperText(__('messages.t_enable_price_below_image_helper'))
                                        ->visible(fn(Get $get) => $get('enable_carousel')),
                                    Toggle::make('enable_favourite_move_to_ad_action')
                                        ->label(__('messages.t_enable_favourite_move_to_ad_action_label'))
                                        ->helperText(__('messages.t_enable_favourite_move_to_ad_action_helper'))
                                        ->visible(fn(Get $get) => $get('enable_carousel')),
                                    Toggle::make('enable_pagination_count')
                                        ->label(__('messages.t_enable_pagination_count_label'))
                                        ->helperText(__('messages.t_enable_pagination_count_helper'))
                                        ->visible(fn(Get $get) => $get('enable_carousel')),
                                    Toggle::make('enable_autoplay')
                                        ->label(__('messages.t_enable_autoplay_label'))
                                        ->helperText(__('messages.t_enable_autoplay_helper'))
                                        ->visible(fn(Get $get) => $get('enable_carousel'))
                                        ->live(onBlur: true),
                                    TextInput::make('autoplay_interval')
                                        ->label(__('messages.t_autoplay_interval_label'))
                                        ->helperText(__('messages.t_autoplay_interval_helper'))
                                        ->required()
                                        ->numeric()
                                        ->visible(fn(Get $get) => $get('enable_autoplay'))
                                        ->minValue(0.1),
                                ])->columns(2)
                            ]),
                    ])->columnSpanFull(),
            ]);
    }
}
