<?php

namespace Adfox\Appearance\Filament\Resources\BannerResource\Pages;

use Adfox\Appearance\Filament\Resources\BannerResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;

class EditBanner extends EditRecord
{
    protected static string $resource = BannerResource::class;

    protected function mutateFormDataBeforeSave(array $data): array
    {
        if(!isset($data['country_id']) && $data['country_id']) {
            $data['state_id'] = null;
            $data['city_id'] = null;

            if(!isset($data['state_id']) && $data['state_id']) {
                $data['city_id'] = null;
            }
        }

        return $data;
    }
    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }
}
