<div>
    <livewire:layout.header isMobileHidden lazy />
    <x-page-header title="{{ $post->title }}" isMobileHidden :$referrer />

    <main id="main-content" class="sticky-scroll-margin">
    <div class="hidden md:block py-4 md:py-6 bg-gray-200 dark:bg-gray-800 classic:bg-gray-50  classic:border-y border-black">
        <div class="container mx-auto px-4">
            <h1 class="text-3xl font-bold tracking-tight text-gray-900 dark:text-white">
               <span> {{ $post->title }} </span>
            </h1>
        </div>
    </div>
    <div class="max-w-5xl mx-auto pt-10 px-4 pb-24 md:pb-10">
        {{-- post content --}}
        <div class="relative py-10 bg-white dark:bg-zinc-800 overflow-hidden rounded-lg shadow border border-gray-200 dark:border-white/10 classic:border-black">

            {{-- Content --}}
            <div class="relative px-4 sm:px-6 lg:px-8 ql-snow">
                <div class="text-lg  mx-auto">
                    {{-- Thumbnail --}}
                    <figure>
                        <img class="w-full rounded-lg lazy" src="{{ $post->image }}" alt="{{ $post->title }}">
                    </figure>

                    {{-- Content --}}
                    <div class="mt-8 dark:text-gray-400 quill-container text-base prose prose-slate  max-w-none dark:prose-invert">
                        {!! $descriptionHtml !!}
                    </div>

                    {{-- Header --}}
                    <h4 class="text-center text-sm mb-4 mt-6 font-medium">{{ __('messages.t_share') }}</h4>

                    <div>
                        <div class="items-center justify-center flex">

                            {{-- Facebook --}}
                            <div x-data x-tooltip="{
                                content: '{{__('messages.t_tooltip_facebook')}}',
                                theme: $store.theme,
                            }" class="grid items-center justify-center mx-4">
                                <a tabindex="0" aria-label="facebook" href="https://www.facebook.com/share.php?u={{ urlencode(url()->current()) }}&t={{ $post->title }}" target="_blank" class="inline-flex justify-center items-center h-12 w-12 border border-transparent rounded-full bg-[#3b5998] focus:outline-none focus:ring-2 focus:ring-primary-600 mx-auto">
                                    <svg class="h-5 w-5 fill-white" version="1.1" viewBox="0 0 512 512" width="100%" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:serif="http://www.serif.com/" xmlns:xlink="http://www.w3.org/1999/xlink"><path d="M374.244,285.825l14.105,-91.961l-88.233,0l0,-59.677c0,-25.159 12.325,-49.682 51.845,-49.682l40.116,0l0,-78.291c0,0 -36.407,-6.214 -71.213,-6.214c-72.67,0 -120.165,44.042 -120.165,123.775l0,70.089l-80.777,0l0,91.961l80.777,0l0,222.31c16.197,2.541 32.798,3.865 49.709,3.865c16.911,0 33.511,-1.324 49.708,-3.865l0,-222.31l74.128,0Z"/></svg>
                                </a>
                                <span class="uppercase font-normal text-xs text-gray-500 mt-4 tracking-widest">{{ __('messages.t_facebook') }}</span>
                            </div>

                            {{-- Twitter --}}
                            <div x-data x-tooltip="{
                                content: '{{__('messages.t_tooltip_twitter')}}',
                                theme: $store.theme,
                            }" class="grid items-center justify-center mx-4">
                                <a aria-label="twitter" href="https://twitter.com/intent/tweet?text={{ $post->title }}%20-%20{{ urlencode(url()->current()) }}%20" target="_blank" class="inline-flex justify-center items-center h-12 w-12 border border-transparent rounded-full focus:outline-none focus:ring-2 focus:ring-primary-600 mx-auto">
                                    <svg width="48px" height="48px" viewBox="0 0 30 30" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <rect width="30" height="30" rx="15" fill="#3F3F46" />
                                    <path d="M19.7447 7.54297H22.2748L16.7473 13.8605L23.25
                            22.4574H18.1584L14.1705 17.2435L9.60746 22.4574H7.07582L12.9881 15.7L6.75
                            7.54297H11.9708L15.5755 12.3087L19.7447 7.54297ZM18.8567 20.943H20.2587L11.209
                            8.97782H9.7046L18.8567 20.943Z" fill="white" />
                                </svg>
                                </a>
                                <span class="uppercase font-normal text-xs text-gray-500 mt-4 tracking-widest">{{ __('messages.t_twitter') }}</span>
                            </div>

                            {{-- Whatsapp --}}
                            <div  x-data x-tooltip="{
                                content: '{{__('messages.t_tooltip_whatsapp')}}',
                                theme: $store.theme,
                            }" class="grid items-center justify-center mx-4">
                                <a aria-label="whatsapp" href="https://api.whatsapp.com/send?text={{ $post->title }}%20{{ urlencode(url()->current()) }}" target="_blank" class="inline-flex justify-center items-center h-12 w-12 border border-transparent rounded-full bg-[#25d366] focus:outline-none focus:ring-2 focus:ring-primary-600 mx-auto">
                                    <svg class="h-5 w-5 fill-white" version="1.1" viewBox="0 0 512 512" width="100%" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:serif="http://www.serif.com/" xmlns:xlink="http://www.w3.org/1999/xlink"><path d="M373.295,307.064c-6.37,-3.188 -37.687,-18.596 -43.526,-20.724c-5.838,-2.126 -10.084,-3.187 -14.331,3.188c-4.246,6.376 -16.454,20.725 -20.17,24.976c-3.715,4.251 -7.431,4.785 -13.8,1.594c-6.37,-3.187 -26.895,-9.913 -51.225,-31.616c-18.935,-16.89 -31.72,-37.749 -35.435,-44.126c-3.716,-6.377 -0.397,-9.824 2.792,-13c2.867,-2.854 6.371,-7.44 9.555,-11.16c3.186,-3.718 4.247,-6.377 6.37,-10.626c2.123,-4.252 1.062,-7.971 -0.532,-11.159c-1.591,-3.188 -14.33,-34.542 -19.638,-47.298c-5.171,-12.419 -10.422,-10.737 -14.332,-10.934c-3.711,-0.184 -7.963,-0.223 -12.208,-0.223c-4.246,0 -11.148,1.594 -16.987,7.969c-5.838,6.377 -22.293,21.789 -22.293,53.14c0,31.355 22.824,61.642 26.009,65.894c3.185,4.252 44.916,68.59 108.816,96.181c15.196,6.564 27.062,10.483 36.312,13.418c15.259,4.849 29.145,4.165 40.121,2.524c12.238,-1.827 37.686,-15.408 42.995,-30.286c5.307,-14.882 5.307,-27.635 3.715,-30.292c-1.592,-2.657 -5.838,-4.251 -12.208,-7.44m-116.224,158.693l-0.086,0c-38.022,-0.015 -75.313,-10.23 -107.845,-29.535l-7.738,-4.592l-80.194,21.037l21.405,-78.19l-5.037,-8.017c-21.211,-33.735 -32.414,-72.726 -32.397,-112.763c0.047,-116.825 95.1,-211.87 211.976,-211.87c56.595,0.019 109.795,22.088 149.801,62.139c40.005,40.05 62.023,93.286 62.001,149.902c-0.048,116.834 -95.1,211.889 -211.886,211.889m180.332,-392.224c-48.131,-48.186 -112.138,-74.735 -180.335,-74.763c-140.514,0 -254.875,114.354 -254.932,254.911c-0.018,44.932 11.72,88.786 34.03,127.448l-36.166,132.102l135.141,-35.45c37.236,20.31 79.159,31.015 121.826,31.029l0.105,0c140.499,0 254.87,-114.366 254.928,-254.925c0.026,-68.117 -26.467,-132.166 -74.597,-180.352" id="WhatsApp-Logo"/></svg>
                                </a>
                                <span class="uppercase font-normal text-xs text-gray-500 mt-4 tracking-widest">{{ __('messages.t_whatsapp') }}</span>
                            </div>


                        </div>
                    </div>

                </div>
            </div>

        </div>

        {{-- Comments --}}
        @if($blogSettings->enable_comments && auth()->check())
        <div class="bg-white dark:bg-zinc-800 shadow rounded-lg sm:overflow-hidden mt-10 border border-gray-200 dark:border-white/10 classic:border-black">
                <div class="divide-y  divide-gray-200 dark:divide-white/10 classic:divide-black">
                    <div class="px-4 py-5 sm:px-6">
                        <h2 class="text-base font-bold tracking-wide text-gray-900 dark:text-gray-100">{{ __('messages.t_comments') }}</h2>
                    </div>
                    @if(count($this->comments))
                    <div class="px-4 py-6 sm:px-6">
                        <ul role="list" class="space-y-8">

                            @foreach ($this->comments as $cm)
                                <li>
                                    <div class="flex space-x-3">
                                        <div class="flex-shrink-0">
                                            <span class="inline-flex items-center justify-center h-10 w-10 rounded-full bg-gray-500 dark:bg-zinc-700">
                                                <span class="font-medium leading-none text-white">
                                                    {{ mb_substr($cm->name, 0, 1) }}
                                                </span>
                                            </span>
                                        </div>
                                        <div>
                                            <div class="text-sm">
                                                <span class="font-bold text-gray-900 dark:text-gray-100">{{ $cm->name }}</span>
                                            </div>
                                            <div class="mt-1 text-sm text-gray-700 dark:text-gray-300">
                                                <p>
                                                    {{ $cm->comment }}
                                                </p>
                                            </div>
                                            <div class="mt-2 text-xs">
                                                <span class="text-gray-400 font-medium">{{ $cm->created_at->diffForHumans() }}</span>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            @endforeach

                        </ul>

                        {{-- Pages --}}
                        @if ($this->comments->hasPages())
                            <div class="bg-gray-100 dark:bg-zinc-800 px-4 py-5 sm:px-6 rounded-bl-lg rounded-br-lg flex justify-center border-t-0 border-r border-l border-b">
                                {!! $this->comments->links('pagination::tailwind') !!}
                            </div>
                        @endif

                    </div>
                    @endif
                </div>

                {{-- Add comment --}}

                    <div class="border-t border-gray-200 dark:border-white/10 classic:border-black bg-gray-50 dark:bg-zinc-800  px-4 py-6 sm:px-6 mt-1 rounded-b-xl">
                        <div class="flex">
                            <div class="min-w-0 flex-1">
                                <form wire:submit="addComment">
                                    {{ $this->form }}
                                    <div class="mt-6">
                                        <x-filament::button type="submit">
                                            {{ __('messages.t_add_comments') }}
                                        </x-filament::button>
                                    </div>
                                </form>

                                <x-filament-actions::modals />
                            </div>

                        </div>
                    </div>


            </div>
        @endif

    </div>
</main>
    <livewire:layout.footer />

    <livewire:layout.bottom-navigation />
</div>
