<?php

namespace Adfox\Blog\Providers;

use Filament\Panel;
use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Relations\Relation;
use Adfox\Blog\BlogPlugin;
use Adfox\Blog\Livewire\PostComponent;
use Livewire\Livewire;

class BlogServiceProvider extends ServiceProvider
{
    public function register()
    {
        Panel::configureUsing(fn (Panel $panel) => $panel->plugin(new BlogPlugin()));
    }

    public function boot()
    {
        Livewire::component('post-component', PostComponent::class);

    }

}
