<?php

namespace Adfox\ECommerce\Models;

use App\Models\Ad;
use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StockTransaction extends Model
{
    use HasFactory, HasUuids;

    protected $fillable = [
        'warehouse_id',
        'ad_id',
        'user_id',
        'transaction_type',
        'quantity',
        'transaction_date',
    ];

    public function ad()
    {
        return $this->belongsTo(Ad::class, 'ad_id', 'id');
    }
}
