<div>
    <!-- Skip links -->
    @include('components.skip-links',['links'=>[
        'main-content'=> __('messages.t_skip_to_main_content')
    ]])

    <livewire:layout.header  lazy  />
    <main class="container mx-auto px-4 py-10 sticky-scroll-margin" id="main-content">
        <div class="grid md:grid-cols-3 gap-x-6">

            <div class="col-span-2">
                <div class="flex justify-end pb-2">
                    @if ($this->feedbackAction->isVisible())
                    {{ $this->feedbackAction }}
                    @endif
                </div>
                <div class="lg:flex lg:justify-between lg:items-center mb-4 grid grid-cols-1">
                    <h1 class="text-xl font-semibold">{{ __('messages.t_feedbacks_about', ['name' => $sellerName]) }} ({{pluralize($feedbackCount , __('messages.t_review'),__('messages.t_reviews'))}} )</h1>
                    <div class="flex items-center gap-x-1">
                        <x-star-rating :rating="$sellerRating" :id="$sellerId" :name="'review'" wire:key="star-rating-seller-{{ $sellerId }}" />
                        <span class="font-semibold text-gray-500 dark:text-gray-200 pt-1">{{__('messages.t_out_off_rating',['sellerRating'=>$sellerRating])}} </span>
                    </div>
                </div>

                <livewire:feedback-list :$sellerId />


            </div>

            <div class="col-span-1 hidden md:block space-y-4">

                <div class="flex items-center flex-col bg-white dark:bg-gray-900/20 p-5 rounded-xl ring-1 ring-gray-950/10 dark:ring-white/10 classic:ring-black ">
                    <div class="flex flex-col md:flex-row justify-between items-center">
                        <div class="grid grid-cols-3 gap-10 font-semibold">
                            <div class="text-center flex items-center flex-col">
                                <div class="text-green-500 flex gap-x-1">
                                    <x-heroicon-o-face-smile class="w-6 h-6" />
                                    <span>{{ $positiveCount }}</span>
                                </div>
                                <span>{{ __('messages.t_positive') }}</span>
                            </div>
                            <div class="text-center flex items-center flex-col">
                                <div class="text-orange-500 flex gap-x-1">
                                    <x-heroicon-o-face-frown class="w-6 h-6" />
                                    <span>{{ $neutralCount }}</span>
                                </div>
                                <span>{{ __('messages.t_neutral') }}</span>
                            </div>
                            <div class="text-center flex items-center flex-col">
                                <div class="text-red-500 flex gap-x-1">
                                    <x-heroicon-o-face-frown class="w-6 h-6" />
                                    <span>{{ $negativeCount }}</span>
                                </div>
                                <span>{{ __('messages.t_negative') }}</span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="flex items-center flex-col bg-white dark:bg-gray-900/20 p-10 rounded-xl ring-1 ring-gray-950/10 dark:ring-white/10 classic:ring-black">
                    <x-heroicon-o-chat-bubble-bottom-center-text class="w-16 h-16" />
                    <p>{{ __('messages.t_your_feedback_is_very_important') }}</p>
                </div>
            </div>
        </div>
    </main>
    <x-filament-actions::modals />
    <livewire:layout.sidebar />
</div>
