<?php

namespace Adfox\Feedback;

use Filament\Panel;
use Filament\Contracts\Plugin;

class FeedbackPlugin implements Plugin
{
    public function getId(): string
    {
        return 'feedback';
    }

    public function register(Panel $panel): void
    {
        if ($panel->getId() == 'admin') {
            $panel->discoverResources(
                in: __DIR__ . '/Filament/Resources',
                for: 'Adfox\\Feedback\\Filament\\Resources'
            )->discoverPages(
                    in: __DIR__ . '/Filament/Pages',
                    for: 'Adfox\\Feedback\\Filament\\Pages'
                );
        }
        if ($panel->getId() == 'app') {
            $panel->discoverResources(
                in: __DIR__ . '/Filament/App/Resources',
                for: 'Adfox\\Feedback\\Filament\\App\\Resources'
            )->discoverPages(
                    in: __DIR__ . '/Filament/App/Pages',
                    for: 'Adfox\\Feedback\\Filament\\App\\Pages'
                );
        }
    }

    public function boot(Panel $panel): void
    {
    }
}
