<?php

namespace Adfox\FieldTemplate\Filament\Resources\FieldTemplateResource\Pages;

use Adfox\FieldTemplate\Filament\Resources\FieldTemplateResource;
use Filament\Actions;
use Filament\Resources\Pages\ListRecords;
use Filament\Resources\Pages\ListRecords\Tab;
use Illuminate\Database\Eloquent\Builder;

class ListFieldTemplates extends ListRecords
{
    protected static string $resource = FieldTemplateResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\CreateAction::make(),
        ];
    }
    public function getTabs(): array
    {
        return [
            'all' => Tab::make(),
            'default' => Tab::make()
                ->modifyQueryUsing(fn(Builder $query) => $query->where('default', true)),
            'custom' => Tab::make()
                ->modifyQueryUsing(fn(Builder $query) => $query->where('default', false)),
        ];
    }
}
