<?php

namespace Adfox\LoginOtp\Filament\Pages;

use App\Settings\LoginOtpSettings;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use Filament\Forms\Components\Placeholder;
use Filament\Forms\Components\Textarea;
use Illuminate\Support\Facades\Config;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;

class LoginOtp extends SettingsPage
{
    use HasPageShield;

    protected static ?string $slug = 'manage-login-otp-settings';

    protected static string $settings = LoginOtpSettings::class;

    protected static ?int $navigationSort = 11; // Adjust the sort order as needed


    public static function getNavigationBadgeTooltip(): ?string
    {
        return 'Twilio OTP Module (Addon) - Passwordless login system using phone number verification via SMS. Requires separate purchase.';
    }

    public static function getNavigationBadge(): ?string
    {
        $isDemo = Config::get('app.demo');
        return  $isDemo  ? 'Addon' : '';
    }

    public static function getNavigationBadgeColor(): ?string
    {
        return 'danger';
    }

    public static function canAccess(): bool
    {
        return userHasPermission('page_LoginOtp');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_ap_login_otp');
    }

    public static function getNavigationGroup(): string
    {
        return __('messages.t_ap_settings');
    }

    public function getTitle(): string
    {
        return __('messages.t_ap_login_otp');
    }
    protected function mutateFormDataBeforeSave(array $data): array
    {
        $previousData = app(LoginOtpSettings::class);
        $filtered = [];

        foreach ($data as $key => $item) {
            if (property_exists($previousData, $key)) {
                $propertyType = gettype($previousData->$key);
                if (is_null($item) && $propertyType === 'string') {
                    $filtered[$key] = '';
                    continue;
                }
            }
            $filtered[$key] = $item;
        }
        return $filtered;
    }

    public function form(Form $form): Form
    {
        $isDemo = Config::get('app.demo');
        return $form
            ->schema([

                Toggle::make('enabled')
                    ->label(__('messages.t_ap_enable_otp'))
                    ->helperText(__('messages.t_ap_enable_otp_helper')),

                $isDemo
                ? Placeholder::make('twilio_sid')
                    ->label(__('messages.t_ap_twilio_sid'))
                    ->content('*****')
                    ->hint(__('messages.t_ap_hidden_demo_mode'))
                : TextInput::make('twilio_sid')
                    ->label(__('messages.t_ap_twilio_sid'))
                    ->required()
                    ->helperText(__('messages.t_ap_twilio_sid_helper')),

                $isDemo
                ? Placeholder::make('auth_token')
                    ->label(__('messages.t_ap_auth_token'))
                    ->content('*****')
                    ->hint(__('messages.t_ap_hidden_demo_mode'))
                : TextInput::make('auth_token')
                    ->label(__('messages.t_ap_auth_token'))
                    ->required()
                    ->helperText(__('messages.t_ap_auth_token_helper')),

                TextInput::make('from_number')
                    ->label(__('messages.t_ap_from_number'))
                    ->required()
                    ->helperText(__('messages.t_ap_from_number_helper')),

            ])
            ->columns(2);
    }
}
