<?php
namespace Adfox\LoginOtp\Livewire;
use Livewire\Component;
use App\Models\MobileVerificationCode;
use App\Models\User;
use App\Providers\RouteServiceProvider;
use App\Settings\GeneralSettings;
use App\Settings\LoginOtpSettings;
use Carbon\Carbon;
use Closure;
use Exception;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Form;
use Filament\Notifications\Notification;
use Illuminate\Support\Facades\Auth;
use Livewire\Attributes\On;
use Twilio\Rest\Client;
use Ysfkaya\FilamentPhoneInput\Forms\PhoneInput;

class VerificationSendOtp extends Component implements HasForms
{

    use InteractsWithForms;
    public $phoneNumber;
    public $otp;
    public ?array $data = [];
    public function mount()
    {
        if (auth()->user()->hasVerifiedEmail()) {
            return redirect()->intended(RouteServiceProvider::HOME);
        }
        $this->form->fill();
        if(Auth::check() && Auth::user()->phone_number){
            $this->form->fill([
                'phone_number'=>Auth::user()->phone_number
            ]);
        }
    }
    public function form(Form $form): Form
    {
        return $form
            ->schema([
                PhoneInput::make('phone_number')
                    ->initialCountry(app(GeneralSettings::class)->default_mobile_country??'us')
                    ->required()
                    ->rules([
                        function () {
                            return function (string $attribute, $value, Closure $fail) {
                                if (Auth::user()->phone_number) {
                                    $user = User::where('id','!=',auth()->id())->where('phone_number',$value)->get();
                                        if($user->count()){
                                            $fail('The :attribute has already been taken');
                                        }


                                }else{
                                    $user = User::where('phone_number', $value)->get();

                                        if($user->count()){
                                            $fail('The :attribute has already been taken');
                                        }

                                }
                            };
                        },
                    ])

                // ...
            ])
            ->statePath('data');
    }

    public function getPhoneNumber(){
        $formData=$this->form->getState();
        $this->phoneNumber = $formData['phone_number'];
        if(Auth::check()){
            User::find(auth()->id())->update([
                'phone_number'=>$this->phoneNumber
            ]);
        }
        $this->sendOtp($this->phoneNumber);
    }

    /**
     * Send Otp to the phone number
     *
     * @param  mixed $number -> user mobile number
     * @return void
     */
    public function sendOtp($phoneNumber,$from='')
    {

        $this->otp = $this->generateOtp();
        $loginOtpSettings = app(LoginOtpSettings::class);




            try {

                $user = User::where('phone_number', $phoneNumber)->first();
                // if (!$user) {
                //    User::find(auth()->id())->update([
                //         'phone_number'=> $phoneNumber
                //     ]);
                // }
                //  User Does not Have Any Existing OTP

                // current time
                $now = Carbon::now();

                // if ($verificationCode && $now->isBefore(Carbon::create($verificationCode->created_at)->addMinutes(2))) {
                //     return $verificationCode;
                // }


                // twilio sid
                $sid = $loginOtpSettings->twilio_sid;

                // twilio token
                $token = $loginOtpSettings->auth_token;
                $twilio = new Client($sid, $token);

                //send otp message to the number
                $message = $twilio->messages
                    ->create(
                        $phoneNumber, // to
                        array(
                            "from" => $loginOtpSettings->from_number,  //twilio from number
                            "body" =>
                            "Your One-Time Password (OTP) for login is: {$this->otp}.
Use this OTP to securely access your account. Please do not share it with anyone. It expires in 5 minutes.
If you didn't request this OTP, please contact support immediately.",
                            // 'statusCallback' => config('app.url').'/twilio/callback',
                        )
                    );
                if ($message->status == 'queued') {

                    //create verification code record
                    MobileVerificationCode::create([
                        'user_id' => auth()->id(),
                        'otp' => $this->otp,
                        'expire_at' => Carbon::now()->addMinutes(5)
                    ]);
                    if ($from=='resend') {
                        //return success message
                        session()->flash('status', 'otp-success');
                    }
                    return redirect()->route('verifyWithOtp',['userId'=>auth()->id()]);
                } else {

                    //return success message
                   return redirect()->back()->with('status', 'otp-failed');
                }
            } catch (Exception $e) {

                 //return error message
                return redirect()->back()->with('status', $e->getMessage());

        }

    }

    /**
     * generate Otp
     *
     * @return number
     */
    public function generateOtp()
    {
        // create 6 digit otp number
        return rand(123456, 999999);
    }


    public function render()
    {
        return view('login-otp::verification-send-otp')->extends('login-otp::layouts.auth')->section('content');
    }

}
