<?php

namespace Adfox\OfflinePayment\Providers;

use Adfox\OfflinePayment\Livewire\OfflinePayment;
use Filament\Panel;
use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Relations\Relation;
use Adfox\OfflinePayment\OfflinePaymentPlugin;
use Livewire\Livewire;

class OfflinePaymentServiceProvider extends ServiceProvider
{
    public function register()
    {
        Panel::configureUsing(fn (Panel $panel) => $panel->plugin(new OfflinePaymentPlugin()));
    }

    public function boot()
    {
        Livewire::component('offline-payment', OfflinePayment::class);
    }

}
