<?php

namespace Adfox\Razorpay\Providers;

use Adfox\Razorpay\Livewire\RazorpayPayment;
use Adfox\Razorpay\RazorpayPlugin;
use Illuminate\Support\ServiceProvider;
use Filament\Panel;
use Livewire\Livewire;

class RazorpayServiceProvider extends ServiceProvider
{
    public function register()
    {
        Panel::configureUsing(fn (Panel $panel) => $panel->plugin(new RazorpayPlugin()));

    }

    public function boot()
    {
        Livewire::component('razorpay-payment', RazorpayPayment::class);

    }

}
