<div class=" h-full min-w-52">
    <style>
        input[type="range"] {
            color: #ef233c;
            --thumb-height: 1.125em;
            --track-height: 0.125em;
            --track-color: rgba(0, 0, 0, 0.2);
            --brightness-hover: 180%;
            --brightness-down: 80%;
            --clip-edges: 0.125em;
        }

        input[type="range"].win10-thumb {
            color: #2b2d42;

            --thumb-height: 1.375em;
            --thumb-width: 0.5em;
            --clip-edges: 0.0125em;
        }

        @media (prefers-color-scheme: dark) {
            html {
                background-color: #000;
            }

            html::before {
                background: radial-gradient(circle at center, #101112, #000);
            }

            input[type="range"] {
                color: #f07167;
                --track-color: rgba(255, 255, 255, 0.1);
            }

            input[type="range"].win10-thumb {
                color: #3a86ff;
            }
        }

        /* === range commons === */
        input[type="range"] {
            position: relative;
            background: #fff0;
            overflow: hidden;
        }

        input[type="range"]:active {
            cursor: grabbing;
        }

        input[type="range"]:disabled {
            filter: grayscale(1);
            opacity: 0.3;
            cursor: not-allowed;
        }

        /* === WebKit specific styles === */
        input[type="range"],
        input[type="range"]::-webkit-slider-runnable-track,
        input[type="range"]::-webkit-slider-thumb {
            -webkit-appearance: none;
            transition: all ease 100ms;
            height: var(--thumb-height);
        }

        input[type="range"]::-webkit-slider-runnable-track,
        input[type="range"]::-webkit-slider-thumb {
            position: relative;
        }

        input[type="range"]::-webkit-slider-thumb {
            --thumb-radius: calc((var(--thumb-height) * 0.5) - 1px);
            --clip-top: calc((var(--thumb-height) - var(--track-height)) * 0.5 - 0.5px);
            --clip-bottom: calc(var(--thumb-height) - var(--clip-top));
            --clip-further: calc(100% + 1px);
            --box-fill: calc(-100vmax - var(--thumb-width, var(--thumb-height))) 0 0 100vmax currentColor;

            width: var(--thumb-width, var(--thumb-height));
            background: linear-gradient(currentColor 0 0) scroll no-repeat left center / 50% calc(var(--track-height) + 1px);
            background-color: currentColor;
            box-shadow: var(--box-fill);
            border-radius: var(--thumb-width, var(--thumb-height));

            filter: brightness(100%);
            clip-path: polygon(100% -1px,
                    var(--clip-edges) -1px,
                    0 var(--clip-top),
                    -100vmax var(--clip-top),
                    -100vmax var(--clip-bottom),
                    0 var(--clip-bottom),
                    var(--clip-edges) 100%,
                    var(--clip-further) var(--clip-further));
        }



        input[type="range"]:active::-webkit-slider-thumb {
            filter: brightness(var(--brightness-down));
            cursor: grabbing;
        }

        input[type="range"]::-webkit-slider-runnable-track {
            background: linear-gradient(var(--track-color) 0 0) scroll no-repeat center / 100% calc(var(--track-height) + 1px);
        }

        input[type="range"]:disabled::-webkit-slider-thumb {
            cursor: not-allowed;
        }

        /* === Firefox specific styles === */
        input[type="range"],
        input[type="range"]::-moz-range-track,
        input[type="range"]::-moz-range-thumb {
            appearance: none;
            transition: all ease 100ms;
            height: var(--thumb-height);
        }

        input[type="range"]::-moz-range-track,
        input[type="range"]::-moz-range-thumb,
        input[type="range"]::-moz-range-progress {
            background: #fff0;
        }

        input[type="range"]::-moz-range-thumb {
            background: currentColor;
            border: 0;
            width: var(--thumb-width, var(--thumb-height));
            border-radius: var(--thumb-width, var(--thumb-height));
            cursor: grab;
        }

        input[type="range"]:active::-moz-range-thumb {
            cursor: grabbing;
        }

        input[type="range"]::-moz-range-track {
            width: 100%;
            background: var(--track-color);
        }

        input[type="range"]::-moz-range-progress {
            appearance: none;
            background: currentColor;
            transition-delay: 30ms;
        }

        input[type="range"]::-moz-range-track,
        input[type="range"]::-moz-range-progress {
            height: calc(var(--track-height) + 1px);
            border-radius: var(--track-height);
        }

        input[type="range"]::-moz-range-thumb,
        input[type="range"]::-moz-range-progress {
            filter: brightness(100%);
        }

        input[type="range"]:active::-moz-range-thumb,
        input[type="range"]:active::-moz-range-progress {
            filter: brightness(var(--brightness-down));
        }

        input[type="range"]:disabled::-moz-range-thumb {
            cursor: not-allowed;
        }
    </style>
    <article wire:key='plan-{{ $plan->id }}'
        class="group flex w-full flex-col overflow-hidden ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10 bg-white p-6 text-slate-700 dark:text-slate-300 flex-auto rounded-xl classic:ring-black {{$homeSettings->enable_hover_animation?'classic-hover-shadow':''}} h-full"
        x-data="{
            ad_count: {{ $plan->ad_count }},
            featured_ad: {{ $plan->feature_ad_count }},
            urgent_ad: {{ $plan->urgent_ad_count }},
            spotlight_ad: {{ $plan->spotlight_ad_count }},
            website_url: {{ $plan->website_url_count }},
            base_price: {{ $plan->price }},
            total_price: {{ $plan->price }},
            item_price: 2,
            calculateTotalPrice() {
                this.total_price = Number(this.base_price +
                    (this.ad_count * {{ $subscriptionSettings->ad_price }}) +
                    (this.featured_ad * {{ $subscriptionSettings->featured_ad_price }}) +
                    (this.urgent_ad * {{ $subscriptionSettings->urgent_ad_price }}) +
                    (this.spotlight_ad * {{ $subscriptionSettings->spotlight_ad_price }}) +
                    (this.website_url * {{ $subscriptionSettings->website_url_price }})).toFixed(2);
            },
            setTruncate(index, element) {
                    if (element.offsetHeight < element.scrollHeight ||
                        element.offsetWidth < element.scrollWidth) {
                        // your element has an overflow, ie. truncated
                        // show read more button
                        this.truncated[index] = true;
                        this.truncatable[index] = true;
                    } else {
                        // your element doesn't have overflow
                        this.truncated[index] = false;
                        this.truncatable[index] = false;

                    }
                },
                isTruncated(index) {
                    return true;
                },
                truncated: [false, false],
                truncatable: [false, false],
        }">
        <h3 class="text-xl text-balance md:text-2xl truncate font-bold text-black dark:text-white"
            aria-describedby="planDescription-{{ $index }}" title="{{ $plan->name }}">{{ $plan->name }}
        </h3>
        <p id="planDescription-{{ $index }}" class="mt-2 text-pretty text-sm font-medium line-clamp-3 "
            x-init="$nextTick(() => { setTruncate({{ $index }}, $el) })">{{ $plan->description }}</p>
        <div class="my-4">
            <!-- Adjustments -->
            <div x-data="{ show: false }">
                <div class="flex items-center gap-1 justify-between">
                    <p id="ad-count-label">
                        <span class="text-sm">{{ __('messages.t_ad_count') }}</span>
                        <span class="text-xs">(<span x-text="ad_count"></span>)</span>
                    </p>
                    @if (!$plan->is_free)
                    <button aria-expanded="false" x-bind:aria-expanded="show.toString()"
                        aria-label="{{ __('messages.t_aria_label_toggle_ad_count_adjustment') }}" type="button"
                        x-on:click="show = !show" class="cursor-pointer" class="font-semibold ">
                        <x-heroicon-o-pencil-square x-show="!show" class="w-4 h-4 " aria-hidden="true" />
                        <x-heroicon-o-x-mark x-show="show" class="w-4 h-4 " aria-hidden="true" />
                    </button>
                    @endif
                </div>
                <input x-cloak x-show="show" type="range" role="slider" min="1" aria-labelledby="ad-count-label"
                    x-bind:aria-valuenow="ad_count" max="{{ $subscriptionSettings->max_adjustable_count }}" step="1"
                    x-model="ad_count" name="ad_count" @input="calculateTotalPrice()" class="win10-thumb">
            </div>

            <!-- Featured Ad Count Adjustment -->
            <div x-data="{ show: false }">
                <div class="flex items-center gap-1 justify-between">
                    <p id="featured-ad-label">
                        <span class="text-sm">{{ __('messages.t_featured_ad') }}</span>
                        <span class="text-xs">(<span x-text="featured_ad"></span>)</span>
                    </p>
                    @if (!$plan->is_free)
                    <button aria-expanded="false" x-bind:aria-expanded="show.toString()"
                        aria-label="{{ __('messages.t_aria_label_toggle_featured_ad_count_adjustment') }}" type="button"
                        x-on:click="show = !show" class="cursor-pointer" class="font-semibold ">
                        <x-heroicon-o-pencil-square x-show="!show" class="w-4 h-4 " aria-hidden="true" />
                        <x-heroicon-o-x-mark x-show="show" class="w-4 h-4 " aria-hidden="true" />
                    </button>
                    @endif
                </div>
                <input x-cloak x-show="show" role="slider" type="range" min="1" aria-labelledby="featured-ad-label"
                    x-bind:aria-valuenow="featured_ad" max="{{ $subscriptionSettings->max_adjustable_count }}" step="1"
                    x-model="featured_ad" name="featured_ad_count" @input="calculateTotalPrice()" class="win10-thumb">
            </div>

            <!-- Urgent Ad Count Adjustment -->
            <div x-data="{ show: false }">
                <div class="flex items-center gap-1 justify-between">
                    <p id="urgent-ad-label">
                        <span class="text-sm">{{ __('messages.t_urgent_ad') }}</span>
                        <span class="text-xs">(<span x-text="urgent_ad"></span>)</span>
                    </p>
                    @if (!$plan->is_free)
                    <button aria-expanded="false" x-bind:aria-expanded="show.toString()"
                        aria-label="{{ __('messages.t_aria_label_toggle_urgent_ad_adjustment') }}" type="button"
                        x-on:click="show = !show" class="cursor-pointer" class="font-semibold ">
                        <x-heroicon-o-pencil-square x-show="!show" class="w-4 h-4 " aria-hidden="true" />
                        <x-heroicon-o-x-mark x-show="show" class="w-4 h-4 " aria-hidden="true" />
                    </button>
                    @endif
                </div>
                <input aria-labelledby="urgent-ad-label" role="slider" x-cloak x-show="show" type="range" min="1"
                    x-bind:aria-valuenow="urgent_ad" max="{{ $subscriptionSettings->max_adjustable_count }}" step="1"
                    x-model="urgent_ad" name="urgent_ad_count" @input="calculateTotalPrice()" class="win10-thumb">
            </div>

            <!-- Spotlight Ad Count Adjustment -->
            <div x-data="{ show: false }">
                <div class="flex items-center gap-1 justify-between">
                    <p id="spotlight-ad-label">
                        <span class="text-sm">{{ __('messages.t_spotlight_display') }}</span>
                        <span class="text-xs">(<span x-text="spotlight_ad"></span>)</span>
                    </p>
                    @if (!$plan->is_free)
                    <button aria-expanded="false" x-bind:aria-expanded="show.toString()"
                        aria-label="{{ __('messages.t_aria_label_toggle_spotlight_ad_adjustment')}}" type="button"
                        x-on:click="show = !show" class="cursor-pointer" class="font-semibold ">
                        <x-heroicon-o-pencil-square x-show="!show" class="w-4 h-4 " aria-hidden="true" />
                        <x-heroicon-o-x-mark x-show="show" class="w-4 h-4 " aria-hidden="true" />
                    </button>
                    @endif
                </div>
                <input aria-labelledby="spotlight-ad-label" x-cloak x-show="show" type="range" min="1"
                    max="{{ $subscriptionSettings->max_adjustable_count }}" step="1" x-model="spotlight_ad"
                    x-bind:aria-valuenow="spotlight_ad" @input="calculateTotalPrice()" class="win10-thumb"
                    name="spotlight_ad_count">
            </div>

            <!-- Website URL Count Adjustment -->
            <div x-data="{ show: false }" class="">
                <div class="flex items-center gap-1 justify-between">
                    <p id="website-url-label">
                        <span class="text-sm">{{ __('messages.t_website_url') }}</span>
                        <span class="text-xs">(<span x-text="website_url"></span>)</span>
                    </p>
                    @if (!$plan->is_free)
                    <button aria-expanded="false" x-bind:aria-expanded="show.toString()"
                        aria-label="{{ __('messages.t_aria_label_toggle_website_url_adjustment') }}" type="button"
                        x-on:click="show = !show" class="cursor-pointer" class="font-semibold ">
                        <x-heroicon-o-pencil-square x-show="!show" class="w-4 h-4 " aria-hidden="true" />
                        <x-heroicon-o-x-mark x-show="show" class="w-4 h-4 " aria-hidden="true" />
                    </button>
                    @endif
                </div>
                <input aria-labelledby="website-url-label" role="slider" aria-valuenow="website_url" x-cloak
                    x-show="show" type="range" min="1" max="{{ $subscriptionSettings->max_adjustable_count }}" step="1"
                    x-model="website_url" @input="calculateTotalPrice()" class="win10-thumb" name="website_url_count">
            </div>
        </div>

        <div class=" mt-auto">
            <div class=" pb-3">
                <!-- Display Total Price -->
                <span class=" text-balance text-3xl md:text-4xl font-medium text-slate-700 dark:text-slate-300">
                    @if(!isDisplayCurrencyAfterPrice())
                    {{ config('app.currency_symbol') }}
                    @endif
                    <span x-text="total_price"></span>
                    @if(isDisplayCurrencyAfterPrice())
                    {{ config('app.currency_symbol') }}
                    @endif
                </span>
                / <span class="mt-2 text-pretty text-xs font-medium">{{ __('messages.t_per') }}
                    {{ __('messages.t_' . $plan->invoice_interval) }}</span>
            </div>

            @if ($plan->is_free)
            <button type="button" tabindex="-1"
                class="cursor-pointer mt-auto w-full whitespace-nowrap bg-primary-700 px-4 py-2 text-center text-sm font-medium tracking-wide text-slate-100 transition hover:opacity-75 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-primary-700 active:opacity-100 active:outline-offset-0 dark:bg-primary-600 dark:text-slate-100 dark:focus-visible:outline-primary-600 rounded-lg disabled:bg-gray-200 disabled:text-gray-900 disabled:cursor-not-allowed"
                @disabled(getActiveSubscriptionPlan() && getActiveSubscriptionPlan()->id == $plan->id)>{{
                __('messages.t_free') }}</button>
            @else
            <button type="button" wire:click="$dispatch('select-plan',{
                    price:total_price,
                    planId:{{ $plan->id }},
                    ad_count:ad_count,
                    featured_ad_count:featured_ad,
                    urgent_ad_count: urgent_ad,
                    spotlight_ad_count: spotlight_ad,
                    website_url_count: website_url,
                    })" id="plan-button-{{ $plan->id }}"
                class="cursor-pointer w-full whitespace-nowrap bg-primary-700 px-4 py-2 text-center text-sm font-medium tracking-wide text-slate-100 transition hover:opacity-75 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-primary-700 active:opacity-100 active:outline-offset-0 dark:bg-primary-600 dark:text-slate-100 dark:focus-visible:outline-primary-600 rounded-lg disabled:bg-gray-200 disabled:text-gray-900 disabled:cursor-not-allowed"
                @disabled(getActiveSubscriptionPlan()?->id == $plan->id)>
                <span wire:loading.remove wire:target="$parent.selectPlan({{ $plan->id }})">{{
                    getActiveSubscriptionPlan() && getActiveSubscriptionPlan()->id == $plan->id ?
                    __('messages.t_current') : __('messages.t_choose') }}</span>
                <x-loading-animation wire:target="$parent.selectPlan({{ $plan->id }})" />
            </button>
            @endif
        </div>
    </article>
</div>