<div class="">
    <style>
        .fi-main {
            padding: 0px;
        }
    </style>
    <header x-data="{ isSticky: true }"
        class=" bg-white  dark:bg-gray-900"
        :class="{ 'sticky top-0 z-50 ': isSticky }" @scroll.window="isSticky = (window.pageYOffset > 30)">
        <div class=" px-5">
            <div class=" flex justify-between items-center py-4">
                <div role="button" class="flex items-center gap-x-2" wire:click="redirectBack()">
                    <x-icon-arrow-left-1 class="w-6 h-6 cursor-pointer rtl:scale-x-[-1]" />
                    <h2 class="md:text-xl text-lg font-semibold">
                        {{ __('messages.t_promote_ad') }}
                    </h2>
                </div>

                @if($promotionType=='multiple')
                <x-button.primary class="min-w-[6rem]" wire:click="$dispatch('proceed-payment')">
                    <x-loading-animation wire:target="$dispatch('proceed-payment')" />{{
                    __('messages.t_proceed_with_payment') }}</x-button.secondary>
                    @endif
                    @if($promotionType=='apply')
                    <x-button.primary class="min-w-[6rem]" wire:click="$dispatch('validate-fields')">
                        <x-loading-animation wire:target="$dispatch('validate-fields')" />{{
                        __('messages.t_apply_plan') }}</x-button.secondary>
                        @endif
            </div>
        </div>
    </header>
    <main class=" container mx-auto px-4 pt-6 pb-20 md:pb-6">
        <livewire:dynamic-component :is="$current" :key="$current" :$id :$selectedAdSlugs :$availablePlanPromotions
            :$promotionType :$selectedPromotions :$promotions />
    </main>
</div>
