<?php

use Adfox\Subscription\Http\Controllers\PaypalPaymentController;
use Adfox\Subscription\Http\Controllers\StripeWebhookController;
use Adfox\Subscription\Http\Controllers\SubscriptionController;
use Adfox\Subscription\Livewire\AdLimitReached;
use Adfox\Subscription\Livewire\MySubscriptions;
use Adfox\Subscription\Livewire\Plan\ChoosePlan;
use Adfox\Subscription\Livewire\Promotion\ChoosePromotion;
use Adfox\Subscription\Livewire\SubscriptionSuccess;
use Illuminate\Support\Facades\Route;

Route::middleware('web')->group(function () {
    Route::post('/stripe/webhook', [StripeWebhookController::class, 'handleWebhook']);
    Route::get('/paypal/webhook', [PaypalPaymentController::class, 'webhookHandle'])->name('paypal.webhook');
});

Route::middleware(['web', 'auth', 'verified'])->group(function () {
    // Route::get('pricing', ChoosePlan::class)->name('pricing');
    Route::get('choose-promotion', ChoosePromotion::class)->name('choose-promotion');
    // Route::get('my-subscriptions', MySubscriptions::class)->name('my-subscriptions');
    Route::get('subscription/success', SubscriptionSuccess::class)->name('subscription.success');
    Route::get('subscription-limit-reached', AdLimitReached::class)->name('subscription.ad-limit-reached');
    Route::post('create-subscription', [SubscriptionController::class, 'createSubscription'])->name('subscription.create');
});
