<?php

namespace Adfox\Subscription\Filament\Resources\SubscriptionResource\RelationManagers;

use Filament\Forms;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Forms\Form;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class InvoicesRelationManager extends RelationManager
{
    protected static string $relationship = 'invoices';

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('subscription_id')
                    ->required()
                    ->maxLength(255),
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->defaultSort('created_at', 'desc')
            ->recordTitleAttribute('subscription_id')
            ->columns([
                Tables\Columns\TextColumn::make('subscription_id'),
                Tables\Columns\TextColumn::make('invoice_id'),
                Tables\Columns\TextColumn::make('currency'),
                Tables\Columns\TextColumn::make('status'),
                Tables\Columns\TextColumn::make('amount_due'),
                Tables\Columns\TextColumn::make('amount_paid'),
                Tables\Columns\TextColumn::make('amount_remaining'),
                Tables\Columns\TextColumn::make('invoice_date')
                ->date('d/m/Y'),
                Tables\Columns\TextColumn::make('due_date')
                ->date('d/m/Y')
            ])
            ->filters([
                //
            ])
            ->headerActions([
                // Tables\Actions\CreateAction::make(),
            ])
            ->actions([
                // Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ])
            ->emptyStateActions([
            ]);
    }
}
