<?php
namespace Adfox\Subscription\Livewire\Plan;

use App\Settings\GeneralSettings;
use App\Settings\PaymentSettings;
use App\Settings\SEOSettings;
use Artesaos\SEOTools\Traits\SEOTools;
use Livewire\Attributes\On;
use Livewire\Attributes\Url;
use Livewire\Component;


class ChoosePlan extends Component
{
    use SEOTools;

    #[Url]
    public $current = 'plan-details';
    public $planDetails = [];
    public $plans = [];
    public $fromUrl;
    public $steps = [
        'plan-details',
        'plan-payment',
    ];

    public function mount()
    {
        $this->fromUrl=url()->previous();
        abortIfSubscriptionDisabled();
        $this->setSeoData();


    }

    public function getPaymentSettingsProperty()
    {
        return app(PaymentSettings::class);
    }

    #[On('select-plan')]
    public function selectPlan($price,$planId,$ad_count,$featured_ad_count,$urgent_ad_count,$spotlight_ad_count,$website_url_count)
    {
        $this->planDetails=[
            'price'=>$price,
            'plan_id'=>$planId,
            'ad_count'=>$ad_count,
            'featured_ad_count'=>$featured_ad_count,
            'urgent_ad_count'=> $urgent_ad_count,
            'spotlight_ad_count'=> $spotlight_ad_count,
            'website_url_count'=> $website_url_count,
        ];
        $this->next();

    }

 /**
     * Update the Current.
     *
     * @param string $current
     */
    #[On('current-step')]
    public function updateCurrentStep($current)
    {
        $this->current = $current;
    }

    public function redirectBack(){
        $this->back();
    }

    /**
    * Set SEO data
    */
    protected function setSeoData()
    {
        $generalSettings = app(GeneralSettings::class);
        $seoSettings = app(SEOSettings::class);


        $separator = $generalSettings->separator ?? '-';
        $siteName = $generalSettings->site_name ?? app_name();

        $title = __('messages.t_seo_choose_plan_page_title') . " $separator " . $siteName;
        $description = $seoSettings->meta_description;

        $this->seo()->setTitle($title);
        $this->seo()->setDescription($description);
    }

    #[On('next-step')]
    public function next()
    {
        $currentIndex = array_search($this->current, $this->steps);

        if ($currentIndex !== false && isset($this->steps[$currentIndex + 1])) {
            $this->current = $this->steps[$currentIndex + 1];
        }
    }

    /**
     * Move to the previous step or redirect to home if at the first step.
     */
    #[On('back')]
    public function back()
    {
        $currentIndex = array_search($this->current, $this->steps);

        if ($currentIndex === 0) {
            // Redirect to home if at the first step
            return redirect($this->fromUrl??route('home'));
        }

        if ($currentIndex !== false && isset($this->steps[$currentIndex - 1])) {
            $this->current = $this->steps[$currentIndex - 1];
        }
    }

    //TODO : CREATE STRIPE PRODUCT AND PRICE
    // public function getPriceId()
    // {
    //     $stripe = new StripeClient($this->paymentGatewaySettings?->secret_key);
    //     $priceIds = $stripe->prices->all();
    //     dd($priceIds->first());
    //     $this->createCheckoutSession($priceIds->first());
    // }

    // public function createProductAndPrice($plan)
    // {
    //     // Set Stripe API key
    //     $stripe = new StripeClient($this->paymentGatewaySettings?->secret_key);
    //     // Create a new product
    //     $product=$stripe->products->create([
    //         'name' => $plan->name,
    //         'description' => $plan->description,
    //     ]);

    //     $price=$stripe->prices->create([
    //         'product' => $product->id,
    //         'unit_amount' => $plan->price*100,
    //         'currency' => $this->paymentGatewaySettings?->currency,
    //         'recurring' => [
    //             'interval' => $plan->invoice_interval,
    //             'interval_count'=>$plan->invoice_period
    //         ],
    //     ]);

    //     return response()->json([
    //         'product_id' => $product->id,
    //         'price_id' => $price->id,
    //     ]);
    // }

    // public function upComingInvoice(){
    //     $stripe = new \Stripe\StripeClient($this->paymentGatewaySettings?->secret_key);
    //     $upcomingInvoices=$stripe->invoices->upcoming(['subscription' => 'sub_1PVAEbGgztvb8gyCaiPmSAYA']);
    //     dd($upcomingInvoices);
    // }
    public function render()
    {
        return view('subscription::plan.choose-plan');
    }
}
