<?php

namespace Adfox\Subscription;

use App\Settings\SubscriptionSettings;
use Filament\Contracts\Plugin;
use Filament\Navigation\NavigationGroup;
use Filament\Panel;

class SubscriptionPlugin implements Plugin
{
    final public function __construct()
    {
    }

    public static function make(): static
    {
        return app(static::class);
    }

    public function getId(): string
    {
        return 'subscription';
    }

    public function register(Panel $panel): void
    {
        $panelId = $panel->getId();

        if ($panelId === 'admin') {
            $this->registerAdminResources($panel);
        } elseif ($panelId === 'app') {
            $this->registerAppResources($panel);
        }
    }

    protected function registerAdminResources(Panel $panel): void
    {
        $panel->discoverResources(
            in: __DIR__ . '/Filament/Resources',
            for: 'Adfox\\Subscription\\Filament\\Resources'
        )->discoverPages(
                in: __DIR__ . '/Filament/Pages',
                for: 'Adfox\\Subscription\\Filament\\Pages'
            );
    }

    protected function registerAppResources(Panel $panel): void
    {
        $panel->discoverResources(
            in: __DIR__ . '/Filament/App/Resources',
            for: 'Adfox\\Subscription\\Filament\\App\\Resources'
        )->discoverPages(
                in: __DIR__ . '/Filament/App/Pages',
                for: 'Adfox\\Subscription\\Filament\\App\\Pages'
            );
    }

    public function boot(Panel $panel): void
    {
        // Additional boot logic if required
    }
}
