<?php

namespace Adfox\WalletSystem\Filament\App\Resources\WalletResource\Pages;

use Adfox\WalletSystem\Filament\App\Resources\WalletResource;
use Adfox\WalletSystem\Filament\App\Resources\WalletResource\Widgets\WalletOverview;
use App\Models\Wallets\BankAccount;
use App\Models\Wallets\Wallet;;
use Filament\Actions;
use Filament\Actions\Action;
use Filament\Resources\Components\Tab;
use Filament\Resources\Pages\ListRecords;
use Illuminate\Database\Eloquent\Builder;

class ListWallets extends ListRecords
{
    protected static string $resource = WalletResource::class;

    protected function getHeaderActions(): array
    {
        $bankExist = BankAccount::with('bank')->where('user_id', auth()->id())->where('is_default', true)->first();
        $totalWallet = Wallet::where('user_id', auth()->id())->first();

        return [
            $bankExist ? Actions\CreateAction::make()
                ->label(__('messages.t_claim_request'))
                ->modalHeading(__('messages.t_claim_request'))
                ->modalSubmitActionLabel(__('messages.t_request_claimed'))
                ->createAnother(false)
                ->mutateFormDataUsing(function (array $data) use ($bankExist): array {
                    $wallet = Wallet::where('user_id', auth()->id())->first();

                    $data['user_id'] = auth()->id();
                    $data['wallet_id'] = $wallet->id;
                    $data['payable_type'] = Wallet::class;
                    $data['payable_id'] = $wallet->id;
                    $data['bank_details'] = [
                        'bank_name' => $bankExist->bank->bank_name,  // Accessing the related bank name
                        'account_number' => $bankExist->account_number,
                        'ifsc_code' => $bankExist->ifsc_code,
                        'account_holder_name' => $bankExist->account_holder_name,
                    ];

                    $wallet->decrement('balance', $data['amount']);

                    return $data;
                })->visible(max($totalWallet?->balance, 0) > 1) : Actions\Action::make('Add_your_bank_account_details')->visible(max($totalWallet?->balance, 0) > 1 && is_ecommerce_active())
                ->label(__('messages.t_add_your_bank_details'))->url(route('filament.app.resources.bank-accounts.create')),
            Action::make('Buy Points')->label(__('messages.t_buy_point'))->url(isEnablePointSystem() ? route('point-vault.buy-point'):'')
            ->hidden(fn()=> isEnablePointSystem() == false)

        ];
    }

    protected function getHeaderWidgets(): array
    {
        return [
            WalletOverview::class,
        ];
    }

    public function getTabs(): array
    {
        $totalWallet = Wallet::where('user_id', auth()->id())->first();

        if (max($totalWallet?->balance, 0) > 1) {
            return [
                __('messages.t_all_option')=> Tab::make(),
                __('messages.t_requested') => Tab::make()
                    ->modifyQueryUsing(fn(Builder $query) => $query->where('status', 'pending')),
                __('messages.t_claimed') => Tab::make()
                    ->modifyQueryUsing(fn(Builder $query) => $query->where('transaction_type', 'claim_request')->where('status', 'completed')),
                __('messages.t_completed') => Tab::make()
                    ->modifyQueryUsing(fn(Builder $query) => $query->where('status', 'completed')),
            ];
        }

        return [];
    }
}
