<?php

namespace Adfox\WalletSystem\Filament\App\Resources\WalletResource\Widgets;

use App\Models\Wallets\Wallet;
use App\Models\Wallets\WalletTransaction;
use Carbon\Carbon;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class WalletOverview extends BaseWidget
{
    protected static ?int $sort = 0;

    protected function getStats(): array
    {
        $totalWallet = Wallet::where('user_id', auth()->id())->first();
        $requestWallet = WalletTransaction::where('status', 'pending')->latest();
        $latestRequestWallet = $requestWallet->first();
        $claimedWallet = WalletTransaction::where('transaction_type', 'claim_request')->where('status', 'completed')->latest();
        $latestClaimedWallet = $claimedWallet->first();

        $starWidgets = [];

        if (max($totalWallet?->balance, 0) > 1 && is_ecommerce_active()) {
            $starWidgets = [
                Stat::make(__('messages.t_current_balance'), $totalWallet?->balance ?? 0)
                    ->description(__('messages.t_last_updated', ['date' => ($totalWallet ? $this->changeDateFormat($totalWallet->created_at) : '-')]))
                    ->icon('heroicon-o-currency-dollar')
                    ->color('success'),

                Stat::make(__('messages.t_request_amount'), $requestWallet->sum('amount') ?? 0)
                    ->color('info')
                    ->description(__('messages.t_last_updated', ['date' => ($latestRequestWallet ? $this->changeDateFormat($latestRequestWallet->created_at) : '-')]))
                    ->icon('heroicon-o-currency-dollar'),

                Stat::make(__('messages.t_claimed_amount'), $claimedWallet->sum('amount') ?? 0)
                    ->color('warning')
                    ->description(__('messages.t_last_updated', ['date' => ($latestClaimedWallet ? $this->changeDateFormat($latestClaimedWallet->created_at) : '-')]))
                    ->icon('heroicon-o-currency-dollar'),
            ];
        }

        return [
            ...isEnablePointSystem() ? [
                Stat::make(__('messages.t_current_point', ['shortName' => getPointSystemSetting('short_name')]), max($totalWallet?->points, 0) . ' ' . getPointSystemSetting('short_name'))
                    ->description(__('messages.t_last_updated', ['date' => ($totalWallet ? $this->changeDateFormat($totalWallet->created_at) : '-')]))
                    ->icon('heroicon-o-currency-dollar')
                    ->color('success'),
            ] : [],
            ...$starWidgets
        ];
    }

    private function changeDateFormat($date)
    {
        return Carbon::parse($date)->format('d M Y h:m a');
    }
}
