<?php

namespace Adfox\Appearance\Traits;


use Filament\Forms\Get;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Radio;
use Filament\Forms\Components\Textarea;

trait BannerFormFields
{
    public static function getBannerFormFields(): array
    {
        return [
            Radio::make('banner_type')
                ->label(__('messages.t_ap_banner_type'))
                ->options([
                    'link' => 'Link',
                    'html' => 'HTML',
                ])
                ->default('link')
                ->inline()
                ->live()
                ->inlineLabel(false), // Displays radio buttons inline
            TextInput::make('link')
                ->url()
                ->label(__('messages.t_ap_link'))
                ->placeholder(__('messages.t_ap_banner_link_placeholder'))
                ->helperText(__('messages.t_ap_banner_link_helper'))
                ->hidden(fn(Get $get) => $get('banner_type') !== 'link'),
            Textarea::make('html')
                ->columnSpanFull()
                ->label(__('messages.t_ap_html'))
                ->rows(5)
                ->placeholder(__('messages.t_ap_banner_html_placeholder'))
                ->helperText(__('messages.t_ap_banner_html_content_helper'))
                ->hidden(fn(Get $get) => $get('banner_type') !== 'html'),
        ];
    }
}
