<div>
    @assets
    <script async src="https://checkout.razorpay.com/v1/checkout.js"></script>
    @endassets
    {{-- wire:click='makeRazorpayPayment'  --}}
    <button type="button" id="rzp-button1"
        class="w-full text-[13px] font-semibold flex justify-center bg-primary-600 hover:bg-primary-700 text-white py-4 px-8 rounded tracking-wide focus:outline-none focus:shadow-outline cursor-pointer disabled:!bg-gray-200 disabled:!text-gray-600 disabled:cursor-not-allowed dark:disabled:!bg-zinc-700 dark:disabled:!text-zinc-400">
        {{ __('messages.t_pay_now') }}
    </button>
@script
 <script>
    setTimeout(function() {
     var options = {
        "key" : "{{$this->getRazorpaySettingsProperty()->key_id }}",
        "currency": "INR",
        "name": "{{ $this->generalSettings?->site_name }}",
        "description": "{{$this->type == 'UG' ? 'Ad Upgrades' : 'Package Purchase'}}",
        "image": "{{ getSettingMediaUrl('general.logo_path', 'logo', asset('images/logo.svg')) }}",
        "order_id": "{{$this->payment_gateway_params['order_id']}}",
        "handler": function (response){
            Livewire.dispatch('razorpay-handler',{'response':response})
        },
        "prefill": {
            "name": "{{ auth()->user()->name }}",
            "email": "{{ auth()->user()->email }}",
        },
        "theme": {
            "color": "{{ $appearanceSettings?->primary_color }}"
        }
    };
    var rzp1 = new Razorpay(options);
    rzp1.on('payment.failed', function (response){
        new FilamentNotification()
        .title(response.error.description)
        .danger()
        .seconds(15)
        .send()

    });
    document.getElementById('rzp-button1').addEventListener("click", function(e){
        rzp1.open();
        e.preventDefault();
    });
    },0);

    </script>
    @endscript
</div>
