<?php

namespace Adfox\Flutterwave\Filament\Pages;

use App\Settings\FlutterwaveSettings;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use App\Models\SettingsProperty;
use Filament\Forms\Components\Placeholder;
use Filament\Forms\Components\SpatieMediaLibraryFileUpload;
use Illuminate\Support\Facades\Config;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;

class FlutterwavePayment extends SettingsPage
{
    use HasPageShield;

    protected static ?string $slug = 'manage-flutterwave-settings';

    protected static string $settings = FlutterwaveSettings::class;

    protected static ?int $navigationSort = 12; // Adjust the sort order as needed


    public static function getNavigationBadgeTooltip(): ?string
    {
        return 'Flutterwave Payment Module (Addon) - Accept payments via Flutterwave gateway, popular in Africa. Requires separate purchase.';
    }

    public static function getNavigationBadge(): ?string
    {
        $isDemo = Config::get('app.demo');
        return  $isDemo  ? 'Addon' : '';
    }

    public static function getNavigationBadgeColor(): ?string
    {
        return 'danger';
    }

    public static function canAccess(): bool
    {
        return userHasPermission('page_FlutterwavePayment');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_ap_flutterwave_settings');
    }

    public static function getNavigationGroup(): string
    {
        return __('messages.t_ap_payment_gateways');
    }

    public function getTitle(): string
    {
        return __('messages.t_ap_flutterwave_settings');
    }
    protected function mutateFormDataBeforeSave(array $data): array
    {
        $previousData = app(FlutterwaveSettings::class);
        $filtered = [];

        foreach ($data as $key => $item) {
            // Check if the property exists in the GeneralSettings class
            if (property_exists($previousData, $key)) {
                // Get the type of the property
                $propertyType = gettype($previousData->$key);

                // If the item is null and the property type is string, set it to an empty string
                if (is_null($item) && $propertyType === 'string') {
                    $filtered[$key] = '';
                    continue;
                }
            }
            // For other cases, just copy the item as is
            $filtered[$key] = $item;
        }
        return $filtered;
    }


    public function form(Form $form): Form
    {
        $currenciesConfig = config('money.currencies');
        $currencyCodes = array_keys($currenciesConfig);
        $isDemo = Config::get('app.demo');
        return $form
            ->schema([
                TextInput::make('name')
                    ->label(__('messages.t_ap_flutterwave_name_label'))
                    ->required()
                    ->helperText(__('messages.t_ap_flutterwave_name_helper_text')),

                Toggle::make('status')
                    ->label(__('messages.t_ap_enable_flutterwave_label'))
                    ->helperText(__('messages.t_ap_enable_flutterwave_helper_text')),

                SpatieMediaLibraryFileUpload::make('logo')
                    ->label(__('messages.t_ap_flutterwave_logo_label'))
                    ->maxSize(maxUploadFileSize())
                    ->collection('flutterwave')
                    ->visibility('public')
                    ->hidden()
                    ->image()
                    ->model(
                        SettingsProperty::getInstance('flutterwave.logo'),
                    )
                    ->helperText(__('messages.t_ap_flutterwave_logo_helper_text')),

                Select::make('currency')
                    ->label(__('messages.t_ap_default_currency_label'))
                    ->options(array_combine($currencyCodes, $currencyCodes))
                    ->required()
                    ->helperText(__('messages.t_ap_default_currency_helper_text')),

                $isDemo ?
                Placeholder::make('public_key')
                    ->label(__('messages.t_ap_flutterwave_public_key_label'))
                    ->content('*****')
                    ->hint(__('messages.t_ap_flutterwave_public_key_hint')) :
                TextInput::make('public_key')
                    ->label(__('messages.t_ap_flutterwave_public_key_label'))
                    ->required()
                    ->helperText(__('messages.t_ap_flutterwave_public_key_helper_text')),

                $isDemo ?
                Placeholder::make('secret_key')
                    ->label(__('messages.t_ap_flutterwave_secret_key_label'))
                    ->content('*****')
                    ->hint(__('messages.t_ap_flutterwave_secret_key_hint')) :
                TextInput::make('secret_key')
                    ->label(__('messages.t_ap_flutterwave_secret_key_label'))
                    ->required()
                    ->helperText(__('messages.t_ap_flutterwave_secret_key_helper_text')),

                $isDemo ?
                Placeholder::make('encryption_key')
                    ->label(__('messages.t_ap_flutterwave_encryption_key_label'))
                    ->content('*****')
                    ->hint(__('messages.t_ap_flutterwave_encryption_key_hint')) :
                TextInput::make('encryption_key')
                    ->label(__('messages.t_ap_flutterwave_encryption_key_label'))
                    ->required()
                    ->helperText(__('messages.t_ap_flutterwave_encryption_key_helper_text')),

                TextInput::make('exchange_rate')
                    ->label(__('messages.t_ap_exchange_rate_label'))
                    ->numeric()
                    ->required()
                    ->helperText(__('messages.t_ap_exchange_rate_helper_text')),
            ])
            ->columns(2);
    }
}
