<?php

namespace Adfox\GoogleLocationKit;

use Filament\Panel;
use Filament\Contracts\Plugin;

class GoogleLocationKitPlugin implements Plugin
{
    public function getId(): string
    {
        return 'google-location-kit';
    }

    public function register(Panel $panel): void
    {
        if ($panel->getId() == 'admin') {
            $panel->discoverResources(
                in: __DIR__ . '/Filament/Resources',
                for: 'Adfox\\GoogleLocationKit\\Filament\\Resources'
            )->discoverPages(
                    in: __DIR__ . '/Filament/Pages',
                    for: 'Adfox\\GoogleLocationKit\\Filament\\Pages'
                );
        }
    }

    public function boot(Panel $panel): void
    {
    }
}
