@props(['item', 'selectedItems'])

@php
    use Carbon\Carbon;

    $today = Carbon::today();
    $isOfferActive = $item->offer_enabled && $item->offer_price && $item->offer_start <= $today && $item->offer_end >= $today;

    $offerPercentage = null;
    if ($isOfferActive && $item->price > $item->offer_price) {
        $discount = $item->price - $item->offer_price;
        $offerPercentage = round(($discount / $item->price) * 100);
    }
@endphp

<button type="button"
        aria-pressed="{{ in_array($item->id, $selectedItems) ? 'true' : 'false' }}"
        wire:click="toggleSelection({{ $item->id }})" class="classic:border-black bg-white border dark:border-white/10 dark:bg-gray-900"
        @class([
                'border font-medium border-gray-200 dark:border-white/10 classic:border-black bg-white rounded-md flex flex-col items-center justify-between cursor-pointer min-w-max transition-all md:hover:transform md:hover:-translate-y-1',
                'border-b-4 border-r-4' => in_array($item->id, $selectedItems),
        ])
    >
    <div class="flex justify-between items-center border-b border-gray-200 dark:border-white/10 classic:border-black py-2 px-4">
        <span>{{ \Number::format(floatval($item->quantity), locale: $paymentSettings->currency_locale) }} {{ $item->quantity == 1 ? __('messages.t_ad') : __('messages.t_ads') }}</span>
        @if(in_array($item->id, $selectedItems))
            <x-heroicon-s-minus-circle class="w-8 h-8 text-danger-600 cursor-pointer" />
        @else
            <x-heroicon-s-plus-circle class="w-8 h-8 text-success-600 cursor-pointer" />
        @endif
    </div>
    <div class="p-4 text-center">
        @if($offerPercentage)
            <div>
                <span class="text-red-600">{{ formatPriceWithCurrency($item->offer_price) }}</span>
                <span class="text-sm text-green-600">({{ $offerPercentage }}% {{ __('messages.t_off') }})</span>
            </div>
            <span class="line-through">{{ formatPriceWithCurrency($item->price) }}</span>
        @else
            <span>{{ formatPriceWithCurrency($item->price) }}</span>
        @endif
    </div>
</button>
