<header x-data="{ isSticky: true }" class="bg-white dark:bg-gray-900" :class="{ 'sticky top-[64px] classic:top-[65px] dark:top-[64px] border-b dark:border-white/10 classic:border-black z-10': isSticky }">
    <div class="mx-auto px-5">
        <div class=" flex justify-between items-center h-16 py-4">
            <div class="flex items-center gap-x-2">
                <button type="button" wire:click="$parent.back()" aria-label="{{__('messages.t_aria_label_back')}}">
                    <x-icon-arrow-left-1 class="w-6 h-6 cursor-pointer" />
                </button>
                <h2 class="md:text-xl text-lg font-semibold">
                    {{ $pkg_type == 'multiple' ? __('messages.t_buy_packages') : __('messages.t_upgrade_ad') }}
                </h2>
            </div>
            @if (count($selectedItems) > 0 && $current == 'package-details')
            <div class="flex gap-x-2 items-center">
                @if($pkg_type != 'apply')
                <div class="flex font-medium gap-x-2 items-center">
                    @if($pkg_type != 'single')
                    {{ count($selectedItems) }} {{ count($selectedItems) === 1 ? __('messages.t_item') : __('messages.t_items') }}
                    <span class="h-6 block w-[0.1rem] bg-gray-600"></span>
                    @endif
                    {{ __('messages.t_total') }} {{ formatPriceWithCurrency($totalPrice) }}
                </div>
                @endif
                <div class="fixed left-0 right-0 bottom-0  md:static bg-white md:bg-transparent px-4 py-3 md:p-0 md:border-none border-t border-gray-200 dark:border-white/10 classic:border-black">
                    @if($pkg_type == 'apply')
                    <x-button.primary class="min-w-[6rem] w-full md:w-auto" wire:click="apply">{{ __('messages.t_apply_package') }}</x-button.secondary>
                        @else
                        <x-button.primary class="min-w-[6rem] w-full md:w-auto !bg-black text-white dark:!bg-primary-600 dark:!text-black" wire:click="next">{{ __('messages.t_proceed_with_payment') }}</x-button.secondary>
                            @endif
                </div>
            </div>
            @endif
        </div>
    </div>
</header>
