<?php

namespace Adfox\Packages\Filament\App\Pages;

use App\Models\Ad;
use App\Settings\PackageSettings;
use Livewire\Attributes\On;
use Livewire\Attributes\Url;
use Illuminate\Support\Facades\Auth;
use Filament\Pages\Page;
use Illuminate\Support\Facades\Schema;

class ChoosePackage extends Page
{
    protected static string $view = 'packages::choose-package';
    protected static ?int $navigationSort = 2;
    protected static bool $shouldRegisterNavigation = false;

    public $current = 'package-details';
    #[Url(keep: true)]
    public $pkg_type = 'multiple';
    #[Url]
    public $ad_id;
    public $selectedItems = [];
    public $fromUrl;

    public $steps = [
        'package-details',
        'package-payment'
    ];

    public static function getNavigationGroup(): ?string
    {
        return __('messages.t_engagements_navigation');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_buy_business_packages');
    }

    public function getTitle(): string
    {
        return __('messages.t_buy_business_packages');
    }

    /**
     * Mount the component and process the Ad and its promotions.
     *
     * @param int|null $id The Ad ID.
     */
    public function mount(): void
    {
        if ($this->ad_id) {
            $this->initializeAd();
        }
        $this->fromUrl = url()->previous();
    }

    /**
     * Initialize the Ad and ensure it belongs to the authenticated user.
     */
    protected function initializeAd(): void
    {
        $ad = Ad::find($this->ad_id);

        // Unauthorized access handling
        if (!$ad || $ad->user_id !== Auth::id()) {
            abort(403, __('messages.unauthorized_action'));
        }
    }

    /**
     * Toggle the selected items.
     *
     * @param array $selectedItems
     */
    #[On('selected-package-items')]
    public function toggleItems(array $selectedItems): void
    {
        $this->selectedItems = $selectedItems;
    }

    /**
     * Move to the next step in the process.
     */
    #[On('next-step')]
    public function next(): void
    {
        $currentIndex = array_search($this->current, $this->steps);

        if ($currentIndex !== false && isset($this->steps[$currentIndex + 1])) {
            $this->current = $this->steps[$currentIndex + 1];
        }
    }

    /**
     * Move to the previous step or redirect to home if at the first step.
     */
    public function back()
    {
        $currentIndex = array_search($this->current, $this->steps);

        if ($currentIndex === 0) {
            // Redirect to home if at the first step
            return redirect($this->fromUrl ?? route('home'));
        }

        if ($currentIndex > 0) {
            $this->current = $this->steps[$currentIndex - 1];
        }
    }

    public static function isDiscovered(): bool
    {
        return app('filament')->hasPlugin('packages') &&
            Schema::hasTable('settings') &&
            app(PackageSettings::class)->status;
    }
}
