<?php

namespace Adfox\Packages;

use App\Settings\PackageSettings;
use Filament\Navigation\NavigationItem;
use Filament\Panel;
use Filament\Contracts\Plugin;
use Illuminate\Support\Facades\Schema;

class PackagesPlugin implements Plugin
{
    public function getId(): string
    {
        return 'packages';
    }

    public function register(Panel $panel): void
    {
        if ($panel->getId() == 'admin') {
            $panel->discoverResources(
                in: __DIR__ . '/Filament/Resources',
                for: 'Adfox\\Packages\\Filament\\Resources'
            )->discoverPages(
                in: __DIR__ . '/Filament/Pages',
                for: 'Adfox\\Packages\\Filament\\Pages'
            );
        }
        if ($panel->getId() == 'app') {
            $panel->discoverResources(
                in: __DIR__ . '/Filament/App/Resources',
                for: 'Adfox\\Packages\\Filament\\App\\Resources'
            )->discoverPages(
                in: __DIR__ . '/Filament/App/Pages',
                for: 'Adfox\\Packages\\Filament\\App\\Pages'
            )
                ->navigationItems([
                    // NavigationItem::make()
                    //     ->label(function () {
                    //         return __('messages.t_buy_business_packages');
                    //     })
                    //     ->visible((app('filament')->hasPlugin('packages') && (Schema::hasTable('settings') && app(PackageSettings::class)->status)))
                    //     ->url('\choose-package')
                    //     ->icon('list')
                    //     ->sort(5)
                ]);
        }
    }

    public function boot(Panel $panel): void {}
}
