<?php

namespace Adfox\Payu\Filament\Pages;

use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use App\Settings\PayuSettings;
use Filament\Forms\Components\Placeholder;
use Illuminate\Support\Facades\Config;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;

class PayuPayment extends SettingsPage
{
    use HasPageShield;

    protected static ?string $slug = 'manage-payu-settings';
    protected static string $settings = PayuSettings::class;
    protected static ?int $navigationSort = 21; // Adjust the sort order as needed

    public static function getNavigationBadgeTooltip(): ?string
    {
        return 'Payu Payment Module (Addon) - Process payments through Payu gateway, popular in India. Requires separate purchase.';
    }

    public static function getNavigationBadge(): ?string
    {
        $isDemo = Config::get('app.demo');
        return  $isDemo  ? 'Addon' : '';
    }

    public static function getNavigationBadgeColor(): ?string
    {
        return 'danger';
    }

    public static function canAccess(): bool
    {
        return userHasPermission('page_PayuPayment');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_ap_payu_settings');
    }

    public static function getNavigationGroup(): string
    {
        return __('messages.t_ap_payment_gateways');
    }

    public function getTitle(): string
    {
        return __('messages.t_ap_payu_settings');
    }

    protected function mutateFormDataBeforeFill(array $data): array
    {
        $data['env_mode'] = env('PAYU_BIZ_MODE');
        $data['merchant_id'] = env('PAYU_BIZ_KEY');
        $data['salt_key'] = env('PAYU_BIZ_SALT');

        return $data;
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        $previousData = app(PayuSettings::class);
        $filtered = [];

        // Mapping environment variables to their respective keys
        $envMapping = [
            'env_mode' => 'PAYU_BIZ_MODE',
            'merchant_id' => 'PAYU_BIZ_KEY',
            'salt_key' => 'PAYU_BIZ_SALT',
        ];

        foreach ($data as $key => $value) {
            // Update environment variables if the key is in the mapping
            if (array_key_exists($key, $envMapping)) {
                setEnvironmentValue($envMapping[$key], $value);
            }

            // Skip if the property doesn't exist in the previous data
            if (!property_exists($previousData, $key)) {
                $filtered[$key] = $value;
                continue;
            }

            // Handle null values for string properties
            $filtered[$key] = is_null($value) && is_string($previousData->$key) ? '' : $value;
        }

        return $filtered;
    }


    public function form(Form $form): Form
    {

        $isDemo = Config::get('app.demo');

        return $form
            ->schema([
                TextInput::make('name')
                    ->label(__('messages.t_ap_payu_name_label'))
                    ->required()
                    ->helperText(__('messages.t_ap_payu_name_helper_text')),

                Toggle::make('status')
                    ->label(__('messages.t_ap_enable_payu_label'))
                    ->helperText(__('messages.t_ap_enable_payu_helper_text')),

                $isDemo ?
                    Placeholder::make('merchant_id')
                    ->label(__('messages.t_ap_payu_merchant_key_label'))
                    ->content(__('messages.t_ap_placeholder_hidden'))
                    ->hint(__('messages.t_ap_placeholder_hidden_hint')) :
                    TextInput::make('merchant_id')
                    ->label(__('messages.t_ap_payu_merchant_key_label'))
                    ->required()
                    ->helperText(__('messages.t_ap_payu_merchant_key_helper_text')),

                $isDemo ?
                    Placeholder::make('salt_key')
                    ->label(__('messages.t_ap_payu_salt_key_label'))
                    ->content(__('messages.t_ap_placeholder_hidden'))
                    ->hint(__('messages.t_ap_placeholder_hidden_hint')) :
                    TextInput::make('salt_key')
                    ->label(__('messages.t_ap_payu_salt_key_label'))
                    ->required()
                    ->helperText(__('messages.t_ap_payu_salt_key_helper_text')),

                Select::make('env_mode')
                    ->label(__('messages.t_ap_payu_env_mode_label'))
                    ->required()
                    ->options([
                        'test' => 'Test',
                        'live' => 'Live',
                    ])
                    ->helperText(__('messages.t_ap_payu_env_mode_helper_text')),

                TextInput::make('exchange_rate')
                    ->label(__('messages.t_ap_exchange_rate_label'))
                    ->numeric()
                    ->required()
                    ->helperText(__('messages.t_ap_exchange_rate_helper_text')),
            ])
            ->columns(2);
    }
}
