<?php

namespace Adfox\Phonepe\Filament\Pages;

use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use App\Settings\PhonepeSettings;
use Filament\Forms\Components\Placeholder;
use Illuminate\Support\Facades\Config;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;

class PhonePeConfiguration extends SettingsPage
{
    use HasPageShield;

    protected static ?string $slug = 'manage-phonepe-settings';

    protected static string $settings = PhonePeSettings::class;

    protected static ?int $navigationSort = 21; // Adjust the sort order as needed

    public static function getNavigationBadgeTooltip(): ?string
    {
        return 'Phonepe Payment Module (Addon) - Process payments through Phonepe gateway, popular in India. Requires separate purchase.';
    }

    public static function getNavigationBadge(): ?string
    {
        $isDemo = Config::get('app.demo');
        return  $isDemo  ? 'Addon' : '';
    }

    public static function getNavigationBadgeColor(): ?string
    {
        return 'danger';
    }

    public static function canAccess(): bool
    {
        return userHasPermission('page_PhonePeConfiguration');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_ap_phonepe_settings');
    }

    public static function getNavigationGroup(): string
    {
        return __('messages.t_ap_payment_gateways');
    }

    public function getTitle(): string
    {
        return __('messages.t_ap_phonepe_settings');
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        $previousData = app(PhonePeSettings::class);
        $filtered = [];

        foreach ($data as $key => $item) {
            if (property_exists($previousData, $key)) {
                $propertyType = gettype($previousData->$key);

                if (is_null($item) && $propertyType === 'string') {
                    $filtered[$key] = '';
                    continue;
                }
            }
            $filtered[$key] = $item;
        }

        return $filtered;
    }

    public function form(Form $form): Form
    {
        $isDemo = Config::get('app.demo');

        return $form
            ->schema([
                TextInput::make('name')
                    ->label(__('messages.t_ap_phonepe_name_label'))
                    ->required()
                    ->helperText(__('messages.t_ap_phonepe_name_helper_text')),

                Toggle::make('status')
                    ->label(__('messages.t_ap_enable_phonepe_label'))
                    ->helperText(__('messages.t_ap_enable_phonepe_helper_text')),

                $isDemo ?
                    Placeholder::make('merchantId')
                    ->label(__('messages.t_ap_phonepe_merchant_key_label'))
                    ->content(__('messages.t_ap_placeholder_hidden'))
                    ->hint(__('messages.t_ap_placeholder_hidden_hint')) :
                    TextInput::make('merchantId')
                    ->label(__('messages.t_ap_phonepe_merchant_key_helper_text'))
                    ->required()
                    ->helperText(__('messages.t_ap_paystack_public_key_helper_text')),

                $isDemo ?
                    Placeholder::make('saltKey')
                    ->label(__('messages.t_ap_phonepe_salt_key_label'))
                    ->content(__('messages.t_ap_placeholder_hidden'))
                    ->hint(__('messages.t_ap_placeholder_hidden_hint')) :
                    TextInput::make('saltKey')
                    ->label(__('messages.t_ap_phonepe_salt_key_label'))
                    ->required()
                    ->helperText(__('messages.t_ap_phonepe_salt_key_helper_text')),

                $isDemo ?
                    Placeholder::make('saltIndex')
                    ->label(__('messages.t_ap_phonepe_salt_index_label'))
                    ->content(__('messages.t_ap_placeholder_hidden'))
                    ->hint(__('messages.t_ap_placeholder_hidden_hint')) :
                    TextInput::make('saltIndex')
                    ->label(__('messages.t_ap_phonepe_salt_index_label'))
                    ->required()
                    ->helperText(__('messages.t_ap_phonepe_secret_index_helper_text')),

                $isDemo ?
                    Placeholder::make('env_mode')
                    ->label(__('messages.t_ap_phonepe_env_mode_label'))
                    ->content(__('messages.t_ap_placeholder_hidden'))
                    ->hint(__('messages.t_ap_placeholder_hidden_hint')) :
                    Select::make('env_mode')
                    ->options([
                        'UAT' => 'Test',
                        'PROD' => 'Live'
                    ])
                    ->label(__('messages.t_ap_phonepe_env_mode_label'))
                    ->required()
                    ->helperText(__('messages.t_ap_phonepe_env_mode_helper_text')),

                TextInput::make('exchange_rate')
                    ->label(__('messages.t_ap_exchange_rate_label'))
                    ->numeric()
                    ->required()
                    ->helperText(__('messages.t_ap_exchange_rate_helper_text')),
            ])
            ->columns(2);
    }
}
