<?php

namespace Adfox\Razorpay\Filament\Pages;

use App\Settings\RazorpaySettings;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use App\Models\SettingsProperty;
use Filament\Forms\Components\Placeholder;
use Filament\Forms\Components\SpatieMediaLibraryFileUpload;
use Illuminate\Support\Facades\Config;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;

class RazorpayPayment extends SettingsPage
{
    use HasPageShield;


    protected static ?string $slug = 'manage-razorpay-settings';

    protected static string $settings = RazorpaySettings::class;

    protected static ?int $navigationSort = 21; // Adjust the sort order as needed


    public static function getNavigationBadgeTooltip(): ?string
    {
        return 'Razorpay Payment Module (Addon) - Accept payments via Razorpay gateway, popular in India. Requires separate purchase.';
    }

    public static function getNavigationBadge(): ?string
    {
        $isDemo = Config::get('app.demo');
        return  $isDemo  ? 'Addon' : '';
    }

    public static function getNavigationBadgeColor(): ?string
    {
        return 'danger';
    }

    public static function canAccess(): bool
    {
        return userHasPermission('page_RazorpayPayment');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_ap_razorpay_settings');
    }

    public static function getNavigationGroup(): string
    {
        return __('messages.t_ap_payment_gateways');
    }

    public function getTitle(): string
    {
        return __('messages.t_ap_razorpay_settings');
    }
    protected function mutateFormDataBeforeSave(array $data): array
    {
        $previousData = app(RazorpaySettings::class);
        $filtered = [];

        foreach ($data as $key => $item) {
            if (property_exists($previousData, $key)) {
                $propertyType = gettype($previousData->$key);

                if (is_null($item) && $propertyType === 'string') {
                    $filtered[$key] = '';
                    continue;
                }
            }
            $filtered[$key] = $item;
        }
        return $filtered;
    }

    public function form(Form $form): Form
    {
        $currenciesConfig = config('money.currencies');
        $currencyCodes = array_keys($currenciesConfig);
        $isDemo = Config::get('app.demo');

        return $form
            ->schema([
                TextInput::make('name')
                    ->label(__('messages.t_ap_razorpay_name'))
                    ->required()
                    ->helperText(__('messages.t_ap_razorpay_name_helper')),

                Toggle::make('status')
                    ->label(__('messages.t_ap_enable_razorpay'))
                    ->helperText(__('messages.t_ap_enable_razorpay_helper')),

                SpatieMediaLibraryFileUpload::make('logo')
                    ->maxSize(maxUploadFileSize())
                    ->label(__('messages.t_ap_razorpay_logo'))
                    ->collection('razorpay')
                    ->visibility('public')
                    ->hidden()
                    ->image()
                    ->model(SettingsProperty::getInstance('razorpay.logo'))
                    ->helperText(__('messages.t_ap_razorpay_logo_helper')),

                Select::make('currency')
                    ->label(__('messages.t_ap_default_currency'))
                    ->options(array_combine($currencyCodes, $currencyCodes))
                    ->required()
                    ->helperText(__('messages.t_ap_default_currency_helper')),

                $isDemo ?
                Placeholder::make('key_id')
                    ->label(__('messages.t_ap_razorpay_key_id'))
                    ->content('*****')
                    ->hint(__('messages.t_ap_razorpay_key_id_hint')) :
                TextInput::make('key_id')
                    ->label(__('messages.t_ap_razorpay_key_id'))
                    ->required()
                    ->helperText(__('messages.t_ap_razorpay_key_id_helper')),

                $isDemo ?
                Placeholder::make('key_secret')
                    ->label(__('messages.t_ap_razorpay_key_secret'))
                    ->content('*****')
                    ->hint(__('messages.t_ap_razorpay_key_secret_hint')) :
                TextInput::make('key_secret')
                    ->label(__('messages.t_ap_razorpay_key_secret'))
                    ->required()
                    ->helperText(__('messages.t_ap_razorpay_key_secret_helper')),

                TextInput::make('exchange_rate')
                    ->label(__('messages.t_ap_exchange_rate'))
                    ->numeric()
                    ->required()
                    ->helperText(__('messages.t_ap_exchange_rate_helper'))
            ])
            ->columns(2);
    }
}
