<?php

namespace Adfox\Subscription\Filament\App\Pages;

use Filament\Pages\Page;
use App\Settings\StripeSettings;
use App\Settings\SubscriptionSettings;
use Exception;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Redirect;

class MySubscriptions extends Page
{
    protected static string $view = 'subscription::filament.app.pages.my-subscriptions';
    protected static ?int $navigationSort = 2;

    public static function getNavigationLabel(): string
    {
        return __('messages.t_my_subscriptions');
    }

    public function getTitle(): string
    {
        return __('messages.t_my_subscriptions');
    }

    public static function getNavigationGroup(): ?string
    {
        return __('messages.t_engagements_navigation');
    }

    /**
     * Mount the component.
     */
    public function mount()
    {
        $subscriptionSettings = $this->getSubscriptionSettings();

        if ($subscriptionSettings->combine_subscriptions_and_orders) {
            return Redirect::route('filament.app.pages.my-orders', ['active-table' => 'subscription']);
        }

        abortIfSubscriptionDisabled();
    }

    /**
     * Update the cancellation status of a subscription.
     *
     * @param mixed $record
     * @param bool $status
     */
    protected function updateSubscriptionCancelStatus($record, bool $status): void
    {
        $stripe = new \Stripe\StripeClient(app(StripeSettings::class)->secret_key);
        $stripe->subscriptions->update(
            $record->subscription_reference,
            ['cancel_at_period_end' => $status]
        );
    }

    /**
     * Retrieve subscription settings.
     *
     * @return SubscriptionSettings
     */
    protected function getSubscriptionSettings(): SubscriptionSettings
    {
        return app(SubscriptionSettings::class);
    }

    /**
     * Check if the page should be discovered.
     *
     * @return bool
     */
    public static function isDiscovered(): bool
    {
        try {
            $subscriptionSettings = app(SubscriptionSettings::class);
            return app('filament')->hasPlugin('subscription')
                && Schema::hasTable('settings')
                && $subscriptionSettings->status
                && !$subscriptionSettings->combine_subscriptions_and_orders;
        } catch (Exception $ex) {
            return false;
        }
    }
}
