<?php

namespace Adfox\Subscription\Livewire;

use App\Settings\GeneralSettings;
use App\Settings\SEOSettings;
use Artesaos\SEOTools\Traits\SEOTools;
use Livewire\Component;

class AdLimitReached extends Component
{
    use SEOTools;

    public $isMobileHidden = false;

    public function mount(){
        $this->setSeoData();
        if(!isSubscriptionAdLimitOver()){
            return redirect()->route('post-ad');
        }

    }

    /**
     * Set SEO data
     */
    protected function setSeoData()
    {
        $generalSettings = app(GeneralSettings::class);
        $seoSettings = app(SEOSettings::class);


        $separator = $generalSettings->separator ?? '-';
        $siteName = $generalSettings->site_name ?? app_name();

        $title = __('messages.t_seo_subscription_ad_limit_reached') . " $separator " . $siteName;
        $description = $seoSettings->meta_description;

        $this->seo()->setTitle($title);
        $this->seo()->setDescription($description);
    }

    /**
     * Render the component view.
     *
     * @return \Illuminate\View\View The view to render.
     */
    public function render()
    {
        return view('subscription::ad-limit-reached');
    }
}
