<?php

namespace Adfox\Subscription\Providers;

use Adfox\Subscription\Livewire\PaymentMethods\PaypalSubscription;
use Adfox\Subscription\Livewire\PaymentMethods\StripeSubscription;
use Adfox\Subscription\Livewire\Plan\ChoosePlan;
use Adfox\Subscription\Livewire\Promotion\ChoosePromotion;
use Adfox\Subscription\Livewire\Plan\PlanDetails;
use Adfox\Subscription\Livewire\Plan\PlanItem;
use Adfox\Subscription\Livewire\Plan\PlanPayment;
use Adfox\Subscription\Livewire\Promotion\PaymentPromotion;
use Adfox\Subscription\Livewire\Promotion\PromotionDetails;
use Adfox\Subscription\Livewire\SubscriptionSuccess;
use Adfox\Subscription\SubscriptionPlugin;
use App\Settings\SubscriptionSettings;
use Filament\Panel;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use Livewire\Livewire;

class SubscriptionServiceProvider extends ServiceProvider
{
    public function register()
    {
        Panel::configureUsing(fn (Panel $panel) => $panel->plugin(new SubscriptionPlugin()));
    }

    public function boot()
    {
        Livewire::component('choose-plan', ChoosePlan::class);
        Livewire::component('plan-details', PlanDetails::class);
        Livewire::component('plan-payment', PlanPayment::class);
        Livewire::component('stripe-subscription', StripeSubscription::class);
        Livewire::component('paypal-subscription', PaypalSubscription::class);
        Livewire::component('subscription-success', SubscriptionSuccess::class);
        // Livewire::component('my-subscriptions', MySubscriptions::class);
        Livewire::component('choose-promotion', ChoosePromotion::class);
        Livewire::component('promotion-details', PromotionDetails::class);
        Livewire::component('payment-promotion', PaymentPromotion::class);
        Livewire::component('plan.plan-item', PlanItem::class);

        View::share('subscriptionSettings', app(SubscriptionSettings::class));
    }
}
