<?php

namespace Adfox\WalletSystem\Filament\App\Resources\BankAccountResource\Pages;

use Adfox\WalletSystem\Filament\App\Resources\BankAccountResource;
use App\Models\Wallets\BankAccount;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Database\Eloquent\Model;

class CreateBankAccount extends CreateRecord
{
    protected static string $resource = BankAccountResource::class;

    protected function handleRecordCreation(array $data): Model
    {
        $bankExist = BankAccount::where('user_id', auth()->id())->where('is_default', true)->exists();

        $data['user_id'] = auth()->id();

        if (!$bankExist) {
            $data['is_default'] = true;
        }

        return static::getModel()::create($data);
    }

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }
}
