<?php

namespace Adfox\WalletSystem\Filament\Resources\EarningResource\Widgets;

use App\Models\Wallets\Commission;
use Carbon\Carbon;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class EarningOverview extends BaseWidget
{
    protected static ?int $sort = 0;

    protected function getStats(): array
    {
        $totalEarning = Commission::latest();
        $totalLatestEarning = $totalEarning->first();
        // $upcomingEarning = Commission::where('status', 'pending')->latest();
        // $upcomingLatestEarning = $upcomingEarning->first();
        // $completedEarning = Commission::where('status', 'completed')->latest();
        // $completedLatestEarning = $completedEarning->first();

        return [
            Stat::make('Total Earnings', $totalEarning->sum('commission_amount'))
                ->description('Last updated: ' .  ($totalLatestEarning ? $this->changeDateFormat($totalLatestEarning->created_at) : '-'))
                ->icon('heroicon-o-currency-dollar')
                ->color('success'),

            //Todo:enable if customize only see the upcoming and completed earnings
            // Stat::make('Upcoming Earnings', $upcomingEarning->sum('commission_amount'))
            //     ->color('info')
            //     ->description('Last updated: ' .  ($upcomingLatestEarning ? $this->changeDateFormat($upcomingLatestEarning->created_at) : '-'))
            //     ->icon('heroicon-o-currency-dollar'),

            // Stat::make('Completed Earnings', $completedEarning->sum('commission_amount'))
            //     ->description('Last updated: ' .  ($completedLatestEarning ? $this->changeDateFormat($completedLatestEarning->created_at) : '-'))
            //     ->icon('heroicon-o-currency-dollar')
            //     ->color('warning'),
        ];
    }

    private function changeDateFormat($date)
    {
        return Carbon::parse($date)->format('d M Y h:s a');
    }
}
