<?php

namespace Adfox\Appearance;

use Filament\Navigation\NavigationGroup;
use Filament\Panel;
use Filament\Contracts\Plugin;

class AppearancePlugin implements Plugin
{
    public function getId(): string
    {
        return 'appearance';
    }

    public function register(Panel $panel): void
    {
        if ($panel->getId() == 'admin') {

            $panel->discoverResources(
                in: __DIR__ . '/Filament/Resources',
                for: 'Adfox\\Appearance\\Filament\\Resources'
            )->discoverPages(
                    in: __DIR__ . '/Filament/Pages',
                    for: 'Adfox\\Appearance\\Filament\\Pages'
                );
        }
    }

    public function boot(Panel $panel): void
    {
    }
}
