<?php

namespace Adfox\Appearance\Filament\Pages;

use App\Filament\Clusters\DesignAppearance;
use App\Settings\AdTemplateSettings;
use App\Settings\AppearanceSettings;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\ViewField;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use Illuminate\Contracts\Support\Htmlable;

class ManageAdTemplate extends SettingsPage
{
    use HasPageShield;

    protected static ?string $cluster = DesignAppearance::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public function getTitle(): string|Htmlable
    {
        return __('messages.t_ap_template');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_ap_template');
    }

    protected static string $settings = AdTemplateSettings::class;

    public ?array $data = [];

    public static function canAccess(): bool
    {
        return userHasPermission('page_ManageAdTemplate');
    }
    // protected function mutateFormDataBeforeSave(array $data): array
    // {
    //     $bannerData=$data['banner_data'];
    //     return $data;
    // }
    public function form(Form $form): Form
    {
        return $form
            ->schema([
                TextInput::make('max_line')
                    ->numeric()
                    ->required()
                    ->columnSpanFull()
                    ->helperText(__('messages.t_ap_max_line_helper'))
                    ->minValue(1)
                    ->label(__('messages.t_ap_max_line')),
                ViewField::make('theme')
                    ->columnSpanFull()
                    ->view('appearance::filament.fields.ad-template'),
            ])
            ->statePath('data');
    }
}
