<?php

namespace Adfox\Blog\Filament\Pages;

use App\Filament\Clusters\Blog as ClustersBlog;
use App\Settings\BlogSettings;
use Filament\Pages\SettingsPage;
use Filament\Forms\Form;
use Filament\Forms\Components\Toggle;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;

class Blog extends SettingsPage
{
    use HasPageShield;

    protected static ?string $slug = 'manage-blog-settings';

    protected static ?string $cluster = ClustersBlog::class;

    protected static ?string $navigationIcon = 'heroicon-o-cog-6-tooth';

    protected static string $settings = BlogSettings::class;

    protected static ?int $navigationSort = 12; // Adjust the sort order as needed

    public static function canAccess(): bool
    {
        return userHasPermission('page_Blog');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_ap_blog_settings');
    }

    public function getTitle(): string
    {
        return __('messages.t_ap_blog_settings');
    }
    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Toggle::make('enable_blog')
                ->label(__('messages.t_ap_enable_blog'))
                ->helperText(__('messages.t_ap_enable_blog_helper')),

            Toggle::make('enable_comments')
                ->label(__('messages.t_ap_enable_comments'))
                ->helperText(__('messages.t_ap_enable_comments_helper')),

            ])
            ->columns(2);
    }
}
