<?php

namespace Adfox\ECommerce\Filament\Pages;

use Adfox\ECommerce\Settings\ECommerceSetting;
use App\Settings\PointVaultSettings;
use App\Filament\Clusters\Ecommerce;
use Filament\Forms\Get;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;

class ECommerceConfiguration extends SettingsPage
{
    use HasPageShield;

    protected static string $settings = ECommerceSetting::class;
    // protected static ?string $slug = 'manage-wallet-commission';

    protected static ?string $cluster = Ecommerce::class;

    protected static ?string $navigationIcon = 'heroicon-o-cog';

    public static function getNavigationLabel(): string
    {
        return __('messages.t_e_commerce_configuration');
    }

    public function getTitle(): string
    {
        return __('messages.t_e_commerce_configuration');
    }

    //TODO: Enable when wallet system is implemented
    public static function isDiscovered(): bool
    {
        return true;
    }

    public static function canAccess(): bool
    {
        return userHasPermission('page_ECommerceConfiguration');
    }

    public function afterSave()
    {
        if (isPointSystemPluginEnabled() && $this->data['enable_e_commerce']) {
            $pointVaultSetting = app(PointVaultSettings::class);
            $pointVaultSetting->enable_point_system = false;
            $pointVaultSetting->save();
        }
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        $previousData = app(ECommerceSetting::class);
        $filtered = [];

        foreach ($data as $key => $item) {
            if (property_exists($previousData, $key)) {
                $propertyType = gettype($previousData->$key);
                if (is_null($item) && $propertyType === 'string') {
                    $filtered[$key] = '';
                    continue;
                }
            }
            $filtered[$key] = $item;
        }

        if (isset($filtered['enable_add_to_cart']) && (!$filtered['enable_add_to_cart'])) {
            $filtered['enable_pay_now'] = false;
        }

        return $filtered;
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Toggle::make('enable_e_commerce')
                    ->label(__('messages.e_commerce.enable_e_commerce.label'))
                    ->helperText(__('messages.e_commerce.enable_e_commerce.helper_text')),

                Toggle::make('enable_add_to_cart')
                    ->label(__('messages.e_commerce.enable_add_to_cart.label'))
                    ->helperText(__('messages.e_commerce.enable_add_to_cart.helper_text'))->live()
                    ->afterStateUpdated(function ($state, $set) {
                        if (!$state) {
                            $set('enable_pay_now', false);
                        }
                    }),

                Toggle::make('enable_pay_now')
                    ->label(__('messages.t_enable_buy_now_label'))
                    ->helperText(__('messages.t_enable_buy_now_helper'))
                    ->visible(fn(Get $get) => $get('enable_add_to_cart')),

                Toggle::make('enable_quantity_option')
                    ->live()
                    ->label(__('messages.e_commerce.enable_quantity_option.label'))
                    ->helperText(__('messages.e_commerce.enable_quantity_option.helper_text')),

                TextInput::make('maximum_quantity_per_item')
                    ->label(__('messages.e_commerce.maximum_quantity_per_item.label'))
                    ->helperText(__('messages.e_commerce.maximum_quantity_per_item.helper_text'))
                    ->numeric()
                    ->required()
                    ->default(1)
                    ->hidden(fn(Get $get) => !$get('enable_quantity_option'))
                    ->minValue(1),   // Set default value
                Toggle::make('enable_tax')
                    ->label(__('messages.t_enable_tax_label'))
                    ->helperText(__('messages.t_enable_tax_helper'))
                    ->live(),
                TextInput::make('tax_rate')
                    ->label(__('messages.t_enable_tax_rate_in_percentage_label'))
                    ->helperText(__('messages.t_enable_tax_rate_in_percentage_helper'))
                    ->numeric()
                    ->required()
                    ->default(1)
                    ->visible(fn(Get $get) => $get('enable_tax'))
                    ->minValue(1),   // Set default value
                Toggle::make('enable_seperate_order_conversion')
                    ->label(__('messages.t_enable_separate_orders'))
                    ->helperText(__('messages.t_enable_separate_orders_helper'))
                    ->default(false),
            ])
            ->columns(2);
    }
}
