<?php

namespace Adfox\ECommerce\Models;

use App\Models\Reservation\Location;
use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Warehouse extends Model
{
    use HasFactory, HasUuids;

    protected static function boot()
    {
        parent::boot();

        // Hook into the "creating" event
        static::creating(function ($model) {
            // Set a default value or modify attributes before creating the model
            if (empty($ad->slug)) {
                $model->user_id = auth()->id(); // Generate a slug from the title
            }
        });
    }

    protected $fillable = [
        'name',
        'capacity',
        'location_id',
        'user_id',
    ];

    public function location()
    {
        return $this->belongsTo(Location::class);
    }

    public function inventories()
    {
        return $this->hasMany(Inventory::class);
    }

    public function stock_transactions()
    {
        return $this->hasMany(StockTransaction::class);
    }
}
